/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity;

import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.core.TickScheduler;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(eventClass=ExplosionEvent.Detonate.class, category="entity")
public class GrieflessCreeperTweak
extends VTweak {
    public static final TagKey<EntityType<?>> CREEPERS = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("forge", "creepers"));
    private ForgeConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("When any Creeper (or entity with EntityType tag #forge:creepers) explodes, all blocks destroyed will plop back into place after a few seconds!").define("ungriefCreepers", true);
    }

    @SubscribeEvent
    public void process(ExplosionEvent evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getExplosion() == null) {
            return;
        }
        if (evt.getExplosion().m_46079_() == null) {
            return;
        }
        if (!evt.getExplosion().m_46079_().m_6095_().m_204039_(CREEPERS)) {
            return;
        }
        LivingEntity exploder = evt.getExplosion().m_46079_();
        Level lvl = exploder.m_9236_();
        AtomicInteger idx = new AtomicInteger();
        evt.getExplosion().m_46081_().sort(Comparator.comparingInt(Vec3i::m_123342_));
        evt.getExplosion().m_46081_().forEach(pos -> {
            BlockState state = lvl.m_8055_(pos);
            BlockEntity ent = lvl.m_7702_(pos);
            if (!state.m_60795_()) {
                TickScheduler.ScheduledTask restoreTask = new TickScheduler.ScheduledTask(() -> {
                    lvl.m_7731_(pos, state, 1026);
                    lvl.m_6550_(pos, lvl.m_8055_(pos), state);
                    lvl.m_5594_(null, pos, state.m_60827_().m_56777_(), SoundSource.BLOCKS, 0.15f, 1.0f);
                    if (ent != null) {
                        lvl.m_151523_(ent);
                    }
                }, 5.0f + (float)idx.get() / 25.0f);
                VTweaks.getInstance().Scheduler.addTask(restoreTask);
                idx.getAndIncrement();
            }
        });
        evt.getExplosion().m_46081_().sort((a, b) -> Integer.compare(b.m_123342_(), a.m_123342_()));
        evt.getExplosion().m_46081_().forEach(pos -> {
            lvl.m_46747_(pos);
            lvl.m_46597_(pos, Blocks.f_50016_.m_49966_());
            lvl.m_6550_(pos, lvl.m_8055_(pos), Blocks.f_50016_.m_49966_());
        });
        evt.getExplosion().m_46080_();
    }
}

