/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(eventClass=PlayerInteractEvent.EntityInteract.class, category="entity")
public class FeatherPluckTweak
extends VTweak {
    public static final TagKey<EntityType<?>> CHICKENS = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("forge", "chickens"));
    public static final TagKey<Item> SHEARS = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "shears"));
    private static final String PLUCK_COOL_DOWN_KEY = "vtweaks:pluck_cool_down";
    private ForgeConfigSpec.BooleanValue enabled;
    private ForgeConfigSpec.LongValue cooldown;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("Allows chicken feathers to be plucked w/ shears").define("enableFeatherPlucking", true);
        this.cooldown = builder.comment("The amount of time (in Milliseconds) between plucks. Defaults to 10 minutes.").defineInRange("featurePluckingCooldown", 600000L, 1L, Long.MAX_VALUE);
    }

    @SubscribeEvent
    public void process(PlayerInteractEvent.EntityInteract evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getTarget() == null || evt.getEntity() == null) {
            return;
        }
        if (!evt.getTarget().m_6095_().m_204039_(CHICKENS)) {
            return;
        }
        Player player = evt.getEntity();
        if (!player.m_21205_().m_204117_(SHEARS)) {
            return;
        }
        if (!this.canPluck(evt.getTarget())) {
            return;
        }
        player.m_6674_(InteractionHand.MAIN_HAND);
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ItemEntity drop = new ItemEntity(evt.getLevel(), evt.getTarget().m_20185_(), evt.getTarget().m_20186_(), evt.getTarget().m_20189_(), new ItemStack((ItemLike)Items.f_42402_));
        evt.getLevel().m_7967_((Entity)drop);
        evt.getTarget().m_6469_(DamageSource.f_19318_, 0.0f);
        this.setCooldown(evt.getTarget());
        if (!player.m_7500_()) {
            player.m_21205_().m_220157_(1, player.m_217043_(), null);
        }
    }

    private boolean canPluck(Entity entity) {
        CompoundTag tag = entity.getPersistentData();
        if (!tag.m_128441_(PLUCK_COOL_DOWN_KEY)) {
            return true;
        }
        long lastTime = tag.m_128454_(PLUCK_COOL_DOWN_KEY);
        return System.currentTimeMillis() - lastTime >= (Long)this.cooldown.get();
    }

    private void setCooldown(Entity entity) {
        CompoundTag tag = entity.getPersistentData();
        tag.m_128356_(PLUCK_COOL_DOWN_KEY, System.currentTimeMillis());
    }
}

