/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.fluidconversion;

import com.google.gson.JsonObject;
import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipe;
import com.oitsjustjose.vtweaks.common.data.helpers.VTJsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidConversionRecipeSerializer
implements RecipeSerializer<FluidConversionRecipe> {
    @NotNull
    public FluidConversionRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject obj) {
        ItemStack input = VTJsonHelpers.deserializeItemStack(obj, "input");
        ItemStack output = VTJsonHelpers.deserializeItemStack(obj, "output");
        ResourceLocation fluid = new ResourceLocation(obj.get("fluid").getAsString());
        return new FluidConversionRecipe(id, input, output, fluid);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull FluidConversionRecipe recipe) {
        buf.writeItemStack(recipe.getInput(), false);
        buf.writeItemStack(recipe.getResult(), false);
        buf.m_130070_(recipe.getFluid().toString());
    }

    @Nullable
    public FluidConversionRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        ItemStack input = buf.m_130267_();
        ItemStack output = buf.m_130267_();
        ResourceLocation fluid = new ResourceLocation(buf.m_130277_());
        return new FluidConversionRecipe(id, input, output, fluid);
    }
}

