/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.anvil;

import com.google.gson.JsonObject;
import com.oitsjustjose.vtweaks.common.data.anvil.AnvilRecipe;
import com.oitsjustjose.vtweaks.common.data.helpers.VTJsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilRecipeSerializer
implements RecipeSerializer<AnvilRecipe> {
    @NotNull
    public AnvilRecipe fromJson(@NotNull ResourceLocation rl, @NotNull JsonObject obj) {
        ItemStack left = VTJsonHelpers.deserializeItemStack(obj, "left");
        ItemStack right = VTJsonHelpers.deserializeItemStack(obj, "right");
        ItemStack result = VTJsonHelpers.deserializeItemStack(obj, "result");
        int cost = obj.get("cost").getAsInt();
        boolean cpl = obj.has("cpFromLeft") && obj.get("cpFromLeft").getAsBoolean();
        boolean cpr = obj.has("cpFromRight") && obj.get("cpFromRight").getAsBoolean();
        return new AnvilRecipe(rl, left, right, result, cost, cpl, cpr);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull AnvilRecipe recipe) {
        buf.writeItemStack(recipe.getLeft(), false);
        buf.writeItemStack(recipe.getRight(), false);
        buf.writeItemStack(recipe.getResult(), false);
        buf.writeInt(recipe.getCost());
        buf.writeBoolean(recipe.shouldResultCopyNbtFromLeft());
        buf.writeBoolean(recipe.shouldResultCopyNbtFromRight());
    }

    @Nullable
    public AnvilRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        ItemStack left = buf.m_130267_();
        ItemStack right = buf.m_130267_();
        ItemStack result = buf.m_130267_();
        int cost = buf.readInt();
        boolean cpl = buf.readBoolean();
        boolean cpr = buf.readBoolean();
        return new AnvilRecipe(id, left, right, result, cost, cpl, cpr);
    }
}

