/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.inventory;

import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.config.ServerConfig;
import fuzs.tradingpost.init.ModRegistry;
import fuzs.tradingpost.mixin.accessor.MerchantMenuAccessor;
import fuzs.tradingpost.world.entity.npc.LocalMerchant;
import fuzs.tradingpost.world.entity.npc.MerchantCollection;
import fuzs.tradingpost.world.inventory.TradingPostContainer;
import fuzs.tradingpost.world.level.block.TradingPostBlock;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.MerchantResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.Block;

public class TradingPostMenu
extends MerchantMenu {
    private final ContainerLevelAccess access;
    private final MerchantCollection traders;
    private final MerchantContainer tradeContainer;
    private int ticks;
    private boolean lockOffers;

    public TradingPostMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, new MerchantCollection(), ContainerLevelAccess.f_39287_);
    }

    public TradingPostMenu(int containerId, Inventory inventory, MerchantCollection merchantCollection, ContainerLevelAccess worldPosCallable) {
        super(containerId, inventory, (Merchant)merchantCollection);
        this.access = worldPosCallable;
        this.traders = merchantCollection;
        ((MerchantMenuAccessor)((Object)this)).setTrader(this.traders);
        this.tradeContainer = new TradingPostContainer(this.traders);
        ((MerchantMenuAccessor)((Object)this)).setTradeContainer(this.tradeContainer);
        this.replaceSlot(0, new Slot((Container)this.tradeContainer, 0, 136, 37));
        this.replaceSlot(1, new Slot((Container)this.tradeContainer, 1, 162, 37));
        this.replaceSlot(2, (Slot)new MerchantResultSlot(inventory.f_35978_, (Merchant)this.traders, this.tradeContainer, 2, 220, 37));
    }

    private void replaceSlot(int index, Slot slot) {
        slot.f_40219_ = index;
        this.f_38839_.set(index, (Object)slot);
    }

    public MenuType<?> m_6772_() {
        return (MenuType)ModRegistry.TRADING_POST_MENU_TYPE.get();
    }

    public boolean m_6875_(Player player) {
        Optional anyTrader = this.access.m_6721_((level, pos) -> this.traders.updateAvailableMerchants(this.f_38840_, (BlockPos)pos, player, ((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).enforceRange && ++this.ticks >= 20));
        if (this.ticks >= 20) {
            this.ticks = 0;
        }
        if (((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).closeScreen && anyTrader.isPresent() && !((Boolean)anyTrader.get()).booleanValue()) {
            player.m_5661_(TradingPostBlock.NO_MERCHANT_FOUND, false);
            return false;
        }
        return TradingPostMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModRegistry.TRADING_POST_BLOCK.get()));
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex == 2) {
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return super.m_7648_(player, slotIndex);
            }
            slot.m_40234_(itemstack1, itemstack);
            this.playTradeSound();
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    private void playTradeSound() {
        Merchant merchant;
        if (!this.traders.m_183595_() && (merchant = this.traders.getCurrentMerchant()) instanceof Entity) {
            Entity entity = (Entity)merchant;
            entity.m_9236_().m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.traders.m_7596_(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public void clearPaymentSlots() {
        ItemStack itemstack1;
        ItemStack itemstack = this.tradeContainer.m_8020_(0);
        if (!itemstack.m_41619_()) {
            if (!this.m_38903_(itemstack, 3, 39, true)) {
                return;
            }
            this.tradeContainer.m_6836_(0, itemstack);
        }
        if (!(itemstack1 = this.tradeContainer.m_8020_(1)).m_41619_()) {
            if (!this.m_38903_(itemstack1, 3, 39, true)) {
                return;
            }
            this.tradeContainer.m_6836_(1, itemstack1);
        }
    }

    public MerchantOffers m_40075_() {
        return this.lockOffers ? new MerchantOffers() : super.m_40075_();
    }

    public MerchantCollection getTraders() {
        return this.traders;
    }

    public void lockOffers(boolean lock) {
        this.lockOffers = lock;
    }

    public void addMerchant(Player playerEntity, int merchantId, Component merchantTitle, MerchantOffers offers, int villagerLevel, int villagerXp, boolean showProgress, boolean canRestock) {
        LocalMerchant merchant = new LocalMerchant(playerEntity, merchantTitle, offers, villagerLevel, villagerXp, showProgress, canRestock);
        this.traders.addMerchant(merchantId, (Merchant)merchant);
    }

    public int m_40071_() {
        return this.traders.getTraderLevel();
    }

    public boolean m_40074_() {
        return this.traders.m_7862_();
    }

    public boolean m_40076_() {
        return this.traders.m_7826_();
    }

    public void m_40048_(boolean showProgressBar) {
        TradingPost.LOGGER.error("Operation setShowProgressBar no supported on trading post, set showProgressBar to merchants directly");
    }

    public void m_40066_(int xpValue) {
        TradingPost.LOGGER.error("Operation setXp no supported on trading post, set xp to merchants directly");
    }

    public void m_40069_(int merchantLevel) {
        TradingPost.LOGGER.error("Operation setMerchantLevel no supported on trading post, set level to merchants directly");
    }

    public void m_40058_(boolean canRestock) {
        TradingPost.LOGGER.error("Operation setCanRestock no supported on trading post, set canRestock to merchants directly");
    }

    public void m_40046_(MerchantOffers offers) {
        TradingPost.LOGGER.error("Operation setOffers no supported on trading post, set offers to merchants directly");
    }
}

