/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.gui.effects;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.stylisheffects.client.gui.effects.AbstractEffectRenderer;
import fuzs.stylisheffects.client.handler.EffectRendererEnvironment;
import fuzs.stylisheffects.client.util.ColorUtil;
import fuzs.stylisheffects.config.ClientConfig;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;

public abstract class CompactEffectRenderer
extends AbstractEffectRenderer {
    private static final ResourceLocation TINY_NUMBERS_TEXTURE = new ResourceLocation("stylisheffects", "textures/font/tiny_numbers.png");

    public CompactEffectRenderer(EffectRendererEnvironment environment) {
        super(environment);
    }

    @Override
    protected int getBackgroundTextureY() {
        return 0;
    }

    protected abstract int getAmplifierOffsetX();

    protected abstract int getAmplifierOffsetY();

    @Override
    protected abstract ClientConfig.CompactWidgetConfig widgetConfig();

    @Override
    protected void drawEffectAmplifier(PoseStack poseStack, int posX, int posY, MobEffectInstance effectinstance) {
        ClientConfig.EffectAmplifier amplifier = this.widgetConfig().effectAmplifier;
        if (amplifier == ClientConfig.EffectAmplifier.NONE || effectinstance.m_19564_() < 1 || effectinstance.m_19564_() > 9) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TINY_NUMBERS_TEXTURE);
        int potionColor = ColorUtil.getEffectColor(this.widgetConfig().amplifierColor, effectinstance);
        float red = (float)(potionColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(potionColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(potionColor >> 0 & 0xFF) / 255.0f;
        int offsetX = amplifier == ClientConfig.EffectAmplifier.TOP_LEFT ? this.getAmplifierOffsetX() : this.getWidth() - this.getAmplifierOffsetX() - 3;
        int offsetY = this.getAmplifierOffsetY();
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)((float)this.rendererConfig().widgetAlpha));
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(posX + offsetX - 1), (int)(posY + offsetY), (float)(5 * (effectinstance.m_19564_() + 1)), (float)0.0f, (int)3, (int)5, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(posX + offsetX + 1), (int)(posY + offsetY), (float)(5 * (effectinstance.m_19564_() + 1)), (float)0.0f, (int)3, (int)5, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(posX + offsetX), (int)(posY + offsetY - 1), (float)(5 * (effectinstance.m_19564_() + 1)), (float)0.0f, (int)3, (int)5, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(posX + offsetX), (int)(posY + offsetY + 1), (float)(5 * (effectinstance.m_19564_() + 1)), (float)0.0f, (int)3, (int)5, (int)256, (int)256);
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)((float)this.rendererConfig().widgetAlpha));
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(posX + offsetX), (int)(posY + offsetY), (float)(5 * (effectinstance.m_19564_() + 1)), (float)0.0f, (int)3, (int)5, (int)256, (int)256);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

