/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.gui.effects;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.api.client.MobEffectWidgetContext;
import fuzs.stylisheffects.client.core.ClientModServices;
import fuzs.stylisheffects.client.gui.effects.EffectWidget;
import fuzs.stylisheffects.client.gui.effects.RenderAreasProvider;
import fuzs.stylisheffects.client.handler.EffectRendererEnvironment;
import fuzs.stylisheffects.client.util.ColorUtil;
import fuzs.stylisheffects.config.ClientConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEffectRenderer
implements EffectWidget,
RenderAreasProvider {
    public static final double DEFAULT_WIDGET_SCALE = 4.0;
    protected static final ResourceLocation EFFECT_BACKGROUND = new ResourceLocation("stylisheffects", "textures/gui/mob_effect_background.png");
    private final EffectRendererEnvironment environment;
    protected GuiComponent screen;
    private int availableWidth;
    private int availableHeight;
    private int startX;
    private int startY;
    private MobEffectWidgetContext.ScreenSide screenSide;
    protected List<MobEffectInstance> activeEffects;

    protected AbstractEffectRenderer(EffectRendererEnvironment environment) {
        this.environment = environment;
    }

    public void setScreenDimensions(GuiComponent screen, int availableWidth, int availableHeight, int startX, int startY, MobEffectWidgetContext.ScreenSide screenSide) {
        this.screen = screen;
        this.availableWidth = availableWidth;
        this.availableHeight = availableHeight;
        this.startX = startX;
        this.startY = startY;
        this.screenSide = screenSide;
        switch (this.environment) {
            case GUI: {
                this.screenSide = this.screenSide.inverse();
                this.availableWidth -= ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetX;
                this.availableHeight -= ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetY;
                this.startX += (this.screenSide.right() ? 1 : -1) * ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetX;
                this.startY += ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetY;
                break;
            }
            case INVENTORY: {
                this.availableWidth -= ((ClientConfig.InventoryRendererConfig)this.rendererConfig()).screenBorderDistance;
            }
        }
    }

    public final void setActiveEffects(Collection<MobEffectInstance> activeEffects) {
        if (activeEffects.isEmpty()) {
            this.activeEffects = null;
            return;
        }
        this.activeEffects = activeEffects.stream().filter(e -> e.m_19557_() > 0).filter(e -> !this.rendererConfig().respectHideParticles || e.m_19575_()).filter(e -> ClientModServices.ABSTRACTIONS.isMobEffectVisibleIn(this.environment, (MobEffectInstance)e)).sorted().collect(Collectors.toList());
    }

    public final boolean isActive() {
        return this.activeEffects != null && !this.activeEffects.isEmpty();
    }

    public final boolean isValid() {
        return !this.rendererConfig().allowFallback || this.getMaxRows() > 0 && this.getMaxColumns() > 0;
    }

    public final double getWidgetScale() {
        return this.rendererConfig().scale / 4.0;
    }

    public final int getScaledWidth() {
        return (int)((double)this.getWidth() * this.getWidgetScale());
    }

    public final int getScaledHeight() {
        return (int)((double)this.getHeight() * this.getWidgetScale());
    }

    public abstract MobEffectWidgetContext.Renderer getEffectRenderer();

    protected abstract int getBackgroundTextureX();

    protected abstract int getBackgroundTextureY();

    protected abstract int getSpriteOffsetX();

    protected abstract int getSpriteOffsetY(boolean var1);

    protected int getDurationOffsetX() {
        return this.getWidth() / 2;
    }

    protected int getDurationOffsetY() {
        return this.getHeight() - 10;
    }

    @Nullable
    public abstract EffectRendererEnvironment.Factory getFallbackRenderer();

    @Override
    public List<Rect2i> getRenderAreas() {
        return this.getEffectPositions(this.activeEffects).stream().map(Pair::getValue).map(pos -> new Rect2i(pos[0], pos[1], this.getScaledWidth(), this.getScaledHeight())).collect(Collectors.toList());
    }

    public List<Pair<MobEffectInstance, int[]>> getEffectPositions(List<MobEffectInstance> activeEffects) {
        ArrayList effectToPos = Lists.newArrayList();
        for (int counter = 0; counter < activeEffects.size(); ++counter) {
            int posX = counter % this.getMaxClampedColumns();
            int posY = counter / this.getMaxClampedColumns();
            effectToPos.add(Pair.of((Object)activeEffects.get(counter), (Object)this.coordsToEffectPosition(posX, posY)));
        }
        return effectToPos;
    }

    protected int getTopOffset() {
        return 0;
    }

    protected int[] coordsToEffectPosition(int coordX, int coordY) {
        int[] renderPositions = new int[2];
        switch (this.screenSide) {
            case LEFT: {
                renderPositions[0] = this.startX - (this.getScaledWidth() + 1) - (this.getScaledWidth() + this.rendererConfig().widgetSpaceX) * coordX;
                renderPositions[1] = this.startY + this.getTopOffset() + this.getAdjustedHeight() * coordY;
                break;
            }
            case RIGHT: {
                renderPositions[0] = this.startX + 1 + (this.getScaledWidth() + this.rendererConfig().widgetSpaceX) * coordX;
                renderPositions[1] = this.startY + this.getTopOffset() + this.getAdjustedHeight() * coordY;
            }
        }
        return renderPositions;
    }

    public void renderEffects(PoseStack poseStack, Minecraft minecraft) {
        for (Pair<MobEffectInstance, int[]> entry : this.getEffectPositions(this.activeEffects)) {
            this.renderWidget(poseStack, ((int[])entry.getValue())[0], ((int[])entry.getValue())[1], minecraft, (MobEffectInstance)entry.getKey());
        }
    }

    protected float getBlinkingAlpha(MobEffectInstance effectinstance) {
        if (!effectinstance.m_19571_() && effectinstance.m_19557_() <= 200) {
            int duration = 10 - effectinstance.m_19557_() / 20;
            return Mth.m_14036_((float)((float)effectinstance.m_19557_() / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.m_14089_((float)((float)effectinstance.m_19557_() * (float)Math.PI / 5.0f)) * Mth.m_14036_((float)((float)duration / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
        }
        return 1.0f;
    }

    private int getAvailableWidth() {
        return Math.min(this.availableWidth, this.rendererConfig().maxColumns * (this.getScaledWidth() + this.rendererConfig().widgetSpaceX));
    }

    private int getAvailableHeight() {
        return Math.min(this.availableHeight, this.rendererConfig().maxRows * (this.getScaledHeight() + this.rendererConfig().widgetSpaceY));
    }

    private int getMaxColumns() {
        return this.getAvailableWidth() / (this.getScaledWidth() + this.rendererConfig().widgetSpaceX);
    }

    public int getMaxClampedColumns() {
        return Mth.m_14045_((int)this.getMaxColumns(), (int)1, (int)this.rendererConfig().maxColumns);
    }

    private int getAdjustedHeight() {
        if (this.getRows() > this.getMaxClampedRows()) {
            return (this.getAvailableHeight() - this.getScaledHeight()) / Math.max(1, this.getRows() - 1);
        }
        return this.getScaledHeight() + this.rendererConfig().widgetSpaceY;
    }

    private int getMaxRows() {
        return this.getAvailableHeight() / (this.getScaledHeight() + this.rendererConfig().widgetSpaceY);
    }

    public int getMaxClampedRows() {
        return Mth.m_14045_((int)this.getMaxRows(), (int)1, (int)this.rendererConfig().maxRows);
    }

    public int getRows() {
        return this.splitByColumns(this.activeEffects.size());
    }

    protected int splitByColumns(int amountToSplit) {
        return (int)Math.ceil((float)amountToSplit / (float)this.getMaxClampedColumns());
    }

    protected ClientConfig.EffectRendererConfig rendererConfig() {
        return switch (this.environment) {
            default -> throw new IncompatibleClassChangeError();
            case EffectRendererEnvironment.INVENTORY -> ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer();
            case EffectRendererEnvironment.GUI -> ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer();
        };
    }

    protected abstract ClientConfig.EffectWidgetConfig widgetConfig();

    @Override
    public final void renderWidget(PoseStack poseStack, int posX, int posY, Minecraft minecraft, MobEffectInstance effectInstance) {
        RenderSystem.m_69478_();
        poseStack.m_85836_();
        double scale = this.getWidgetScale();
        if (scale != 1.0) {
            poseStack.m_85841_((float)scale, (float)scale, 1.0f);
            posX = (int)((double)posX / scale);
            posY = (int)((double)posY / scale);
        }
        this.drawWidgetBackground(poseStack, posX, posY, effectInstance);
        this.drawEffectSprite(poseStack, posX, posY, minecraft, effectInstance);
        this.drawEffectText(poseStack, posX, posY, minecraft, effectInstance);
        this.drawEffectAmplifier(poseStack, posX, posY, effectInstance);
        poseStack.m_85849_();
    }

    protected void drawWidgetBackground(PoseStack poseStack, int posX, int posY, MobEffectInstance effectInstance) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)EFFECT_BACKGROUND);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.rendererConfig().widgetAlpha));
        int backgroundY = this.getBackgroundY(effectInstance, this.widgetConfig().ambientBorder, this.widgetConfig().qualityBorder);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)posX, (int)posY, (float)this.getBackgroundTextureX(), (float)(this.getBackgroundTextureY() + backgroundY * this.getHeight()), (int)this.getWidth(), (int)this.getHeight(), (int)256, (int)256);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawEffectSprite(PoseStack poseStack, int posX, int posY, Minecraft minecraft, MobEffectInstance effectinstance) {
        if (this.drawCustomEffect(poseStack, posX, posY, effectinstance)) {
            return;
        }
        MobEffectTextureManager potionspriteuploader = minecraft.m_91306_();
        TextureAtlasSprite textureatlassprite = potionspriteuploader.m_118732_(effectinstance.m_19544_());
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
        float blinkingAlpha = this.widgetConfig().blinkingAlpha ? this.getBlinkingAlpha(effectinstance) : 1.0f;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(blinkingAlpha * (float)this.rendererConfig().widgetAlpha));
        GuiComponent.m_93200_((PoseStack)poseStack, (int)(posX + this.getSpriteOffsetX()), (int)(posY + this.getSpriteOffsetY(!this.widgetConfig().ambientDuration && effectinstance.m_19571_())), (int)0, (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private boolean drawCustomEffect(PoseStack poseStack, int posX, int posY, MobEffectInstance effectinstance) {
        GuiComponent guiComponent = this.screen;
        if (guiComponent instanceof EffectRenderingInventoryScreen) {
            EffectRenderingInventoryScreen effectInventoryScreen = (EffectRenderingInventoryScreen)guiComponent;
            return ClientModServices.ABSTRACTIONS.renderInventoryIcon(effectinstance, effectInventoryScreen, poseStack, posX, posY, effectInventoryScreen.m_93252_());
        }
        guiComponent = this.screen;
        if (guiComponent instanceof Gui) {
            Gui gui = (Gui)guiComponent;
            return ClientModServices.ABSTRACTIONS.renderGuiIcon(effectinstance, gui, poseStack, posX, posY, this.screen.m_93252_(), this.getBlinkingAlpha(effectinstance) * (float)this.rendererConfig().widgetAlpha);
        }
        return false;
    }

    protected void drawEffectText(PoseStack poseStack, int posX, int posY, Minecraft minecraft, MobEffectInstance effectinstance) {
        if (!this.widgetConfig().ambientDuration && effectinstance.m_19571_()) {
            return;
        }
        this.getEffectDuration(effectinstance, this.widgetConfig().longDuration).ifPresent(durationComponent -> {
            int potionColor = ColorUtil.getEffectColor(this.widgetConfig().durationColor, effectinstance);
            int alpha = (int)(this.rendererConfig().widgetAlpha * 255.0) << 24;
            FormattedCharSequence ireorderingprocessor = durationComponent.m_7532_();
            int offsetX = this.getDurationOffsetX();
            int offsetY = this.getDurationOffsetY();
            minecraft.f_91062_.m_92877_(poseStack, ireorderingprocessor, (float)(posX + offsetX - 1 - minecraft.f_91062_.m_92724_(ireorderingprocessor) / 2), (float)(posY + offsetY), alpha);
            minecraft.f_91062_.m_92877_(poseStack, ireorderingprocessor, (float)(posX + offsetX + 1 - minecraft.f_91062_.m_92724_(ireorderingprocessor) / 2), (float)(posY + offsetY), alpha);
            minecraft.f_91062_.m_92877_(poseStack, ireorderingprocessor, (float)(posX + offsetX - minecraft.f_91062_.m_92724_(ireorderingprocessor) / 2), (float)(posY + offsetY - 1), alpha);
            minecraft.f_91062_.m_92877_(poseStack, ireorderingprocessor, (float)(posX + offsetX - minecraft.f_91062_.m_92724_(ireorderingprocessor) / 2), (float)(posY + offsetY + 1), alpha);
            minecraft.f_91062_.m_92877_(poseStack, ireorderingprocessor, (float)(posX + offsetX - minecraft.f_91062_.m_92724_(ireorderingprocessor) / 2), (float)(posY + offsetY), alpha | potionColor);
        });
    }

    protected void drawEffectAmplifier(PoseStack poseStack, int posX, int posY, MobEffectInstance effectinstance) {
    }

    protected int getBackgroundY(MobEffectInstance effectInstance, boolean showAmbient, boolean showQuality) {
        if (showAmbient && effectInstance.m_19571_()) {
            return 1;
        }
        if (showQuality) {
            return effectInstance.m_19544_().m_19486_() ? 2 : 3;
        }
        return 0;
    }

    protected Optional<Component> getEffectDuration(MobEffectInstance effectInstance, ClientConfig.LongDuration longDuration) {
        String effectDuration = MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f);
        if (effectDuration.equals("**:**")) {
            switch (longDuration) {
                case INFINITY: {
                    return Optional.of(Component.m_237113_((String)"\u221e"));
                }
                case NONE: {
                    return Optional.empty();
                }
            }
        }
        return Optional.of(Component.m_237113_((String)effectDuration));
    }

    public static String formatTickDuration(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        int hours = minutes / 60;
        int days = hours / 24;
        seconds %= 60;
        minutes %= 60;
        hours %= 24;
        if (days > 0) {
            return days + "d";
        }
        if (hours > 0) {
            return hours + "h";
        }
        if (minutes > 0) {
            return minutes + "m";
        }
        return seconds + "s";
    }

    public Optional<List<Component>> getHoveredEffectTooltip(int mouseX, int mouseY, TooltipFlag tooltipFlag) {
        if (this.environment == EffectRendererEnvironment.INVENTORY && ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().hoveringTooltip) {
            return this.getHoveredEffect(mouseX, mouseY).map(effectInstance -> {
                List<Component> tooltipLines = this.makeEffectTooltip((MobEffectInstance)effectInstance, ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().tooltipDuration);
                ClientModServices.ABSTRACTIONS.onGatherEffectTooltipLines(this.buildContext((MobEffectInstance)effectInstance), tooltipLines, tooltipFlag);
                return tooltipLines;
            });
        }
        return Optional.empty();
    }

    public MobEffectWidgetContext buildContext(MobEffectInstance effectInstance) {
        return MobEffectWidgetContext.of(effectInstance, this.getEffectRenderer(), this.screenSide);
    }

    public Optional<MobEffectInstance> getHoveredEffect(int mouseX, int mouseY) {
        for (Map.Entry entry : Lists.reverse(this.getEffectPositions(this.activeEffects))) {
            if (!this.isMouseOver(((int[])entry.getValue())[0], ((int[])entry.getValue())[1], mouseX, mouseY)) continue;
            return Optional.of((MobEffectInstance)entry.getKey());
        }
        return Optional.empty();
    }

    private boolean isMouseOver(int posX, int posY, int mouseX, int mouseY) {
        return mouseX >= posX && mouseX <= posX + this.getScaledWidth() && mouseY >= posY && mouseY <= posY + this.getScaledHeight();
    }

    protected List<Component> makeEffectTooltip(MobEffectInstance effectInstance, boolean withDuration) {
        ArrayList tooltip = Lists.newArrayList();
        MutableComponent textComponent = this.getEffectDisplayName(effectInstance);
        if (withDuration && !effectInstance.m_19577_()) {
            textComponent.m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"(").m_130946_(MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f)).m_130946_(")").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add(textComponent);
        String descriptionKey = effectInstance.m_19544_().m_19481_() + ".description";
        if (Language.m_128107_().m_6722_(descriptionKey)) {
            tooltip.add(Component.m_237115_((String)descriptionKey).m_130940_(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    protected MutableComponent getEffectDisplayName(MobEffectInstance effectInstance) {
        MutableComponent textComponent = Component.m_237119_().m_7220_(effectInstance.m_19544_().m_19482_());
        if (effectInstance.m_19564_() >= 1 && effectInstance.m_19564_() <= 9) {
            textComponent.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + (effectInstance.m_19564_() + 1))));
        }
        return textComponent;
    }
}

