/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStackHelper {
    public static Item getTrueItem(@NotNull ItemStack stack) {
        return stack.m_41720_();
    }

    @NotNull
    public static ItemStack getItemPrototype(@NotNull ItemStack stack) {
        return stack.m_41777_();
    }

    @NotNull
    public static ItemStack encodeItemStack(@NotNull ItemStack stack) {
        if (!stack.m_41619_()) {
            return stack;
        }
        ItemStack proto = ItemStackHelper.getItemPrototype(stack);
        if (proto.m_41619_()) {
            return stack;
        }
        CompoundTag tag = proto.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            proto.m_41751_(tag);
        }
        tag.m_128405_("__storagedrawers_count", stack.m_41613_());
        return proto;
    }

    public static ItemStack encodeItemStack(@NotNull ItemStack proto, int count) {
        if (!proto.m_41619_() && count > 0 && count < 128) {
            ItemStack stack = proto.m_41777_();
            stack.m_41764_(count);
            return stack;
        }
        if (count == 0 || count >= 128) {
            ItemStack stack = proto.m_41777_();
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
                stack.m_41751_(tag);
            }
            tag.m_128405_("__storagedrawers_count", count);
            return stack;
        }
        return proto.m_41777_();
    }

    public static ItemStack decodeItemStack(@NotNull ItemStack stack) {
        int count = ItemStackHelper.decodedCount(stack);
        ItemStack decode = ItemStackHelper.stripDecoding(stack);
        decode.m_41764_(count);
        return decode;
    }

    public static ItemStack decodeItemStackPrototype(@NotNull ItemStack stack) {
        ItemStack decode = ItemStackHelper.stripDecoding(stack);
        decode.m_41764_(1);
        return decode;
    }

    public static int decodedCount(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("__storagedrawers_count")) {
            return tag.m_128451_("__storagedrawers_count");
        }
        return stack.m_41613_();
    }

    public static ItemStack stripDecoding(@NotNull ItemStack stack) {
        ItemStack decode = stack.m_41777_();
        CompoundTag tag = decode.m_41783_();
        if (tag != null && tag.m_128441_("__storagedrawers_count")) {
            tag.m_128473_("__storagedrawers_count");
            if (tag.m_128440_() == 0) {
                decode.m_41751_(null);
            } else {
                decode.m_41751_(tag);
            }
        }
        return decode;
    }

    public static boolean isStackEncoded(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        return tag.m_128441_("__storagedrawers_count");
    }
}

