/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.config;

import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.config.CrosshairVisibility;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;

public enum Perspective {
    FIRST_PERSON(CameraType.FIRST_PERSON, CrosshairVisibility.ALWAYS),
    THIRD_PERSON_BACK(CameraType.THIRD_PERSON_BACK, CrosshairVisibility.NEVER),
    THIRD_PERSON_FRONT(CameraType.THIRD_PERSON_FRONT, CrosshairVisibility.NEVER),
    SHOULDER_SURFING(CameraType.THIRD_PERSON_BACK, CrosshairVisibility.ALWAYS);

    private final CameraType cameraType;
    private final CrosshairVisibility defaultCrosshairVisibility;

    private Perspective(CameraType cameraType, CrosshairVisibility defaultCrosshairVisibility) {
        this.cameraType = cameraType;
        this.defaultCrosshairVisibility = defaultCrosshairVisibility;
    }

    public CameraType getCameraType() {
        return this.cameraType;
    }

    public CrosshairVisibility getDefaultCrosshairVisibility() {
        return this.defaultCrosshairVisibility;
    }

    public Perspective next() {
        Perspective next = Perspective.values()[(this.ordinal() + 1) % Perspective.values().length];
        if (Config.CLIENT.replaceDefaultPerspective()) {
            if (this == FIRST_PERSON) {
                return SHOULDER_SURFING;
            }
            if (this == SHOULDER_SURFING) {
                return THIRD_PERSON_FRONT;
            }
            if (this == THIRD_PERSON_FRONT) {
                return FIRST_PERSON;
            }
        }
        return next;
    }

    public static Perspective of(CameraType cameraType, boolean shoulderSurfing) {
        switch (cameraType) {
            case FIRST_PERSON: {
                return FIRST_PERSON;
            }
            case THIRD_PERSON_BACK: {
                return shoulderSurfing ? SHOULDER_SURFING : THIRD_PERSON_BACK;
            }
            case THIRD_PERSON_FRONT: {
                return THIRD_PERSON_FRONT;
            }
        }
        return FIRST_PERSON;
    }

    public static Perspective current() {
        return Perspective.of(Minecraft.m_91087_().f_91066_.m_92176_(), ShoulderInstance.getInstance().doShoulderSurfing());
    }
}

