/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity;

import com.mrbysco.raided.entity.projectiles.IncineratorFireball;
import com.mrbysco.raided.registry.RaidedRegistry;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Incinerator
extends AbstractIllager
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> THROWING_DATA = SynchedEntityData.m_135353_(Incinerator.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WEAPON_TYPE_DATA = SynchedEntityData.m_135353_(Incinerator.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean animationPlay;
    private int animationTimer;
    private int switchHealth;
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 15.0f);
    private final MeleeAttackGoal incineratorMeleeGoal = new IncineratorMeleeAttackGoal(this);

    public Incinerator(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.0f;
        this.switchHealth = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 40, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.75));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(THROWING_DATA, (Object)false);
        this.f_19804_.m_135372_(WEAPON_TYPE_DATA, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.275f).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("WeaponType", this.getWeaponType());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("WeaponType")) {
            int typeID = tag.m_128451_("WeaponType");
            this.setWeaponType(typeID);
        }
    }

    public int getWeaponType() {
        return (Integer)this.f_19804_.m_135370_(WEAPON_TYPE_DATA);
    }

    private void setWeaponType(int type) {
        this.f_19804_.m_135381_(WEAPON_TYPE_DATA, (Object)type);
    }

    public boolean isThrowing() {
        return (Boolean)this.f_19804_.m_135370_(THROWING_DATA);
    }

    private void setThrowing(boolean throwing) {
        this.f_19804_.m_135381_(THROWING_DATA, (Object)throwing);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        this.m_5496_(SoundEvents.f_11705_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20191_().f_82289_ + (double)target.m_20206_() / 2.0 - (this.m_20186_() + (double)this.m_20206_() / 2.0);
        double d2 = target.m_20189_() - this.m_20189_();
        double f1 = (double)Mth.m_14116_((float)distanceFactor) * 0.5;
        for (int i = 0; i < 3; ++i) {
            IncineratorFireball fireball = new IncineratorFireball(this.f_19853_, (LivingEntity)this, d0 + this.f_19796_.m_188583_() * f1, d1, d2 + this.f_19796_.m_188583_() * f1);
            fireball.m_6034_(fireball.m_20185_(), fireball.m_20186_() + (double)this.m_20206_() / 2.0 + 0.5, fireball.m_20189_());
            this.f_19853_.m_7967_((Entity)fireball);
        }
        this.setThrowing(true);
        this.animationPlay = true;
        this.animationTimer = 0;
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            entity.m_20254_(4);
        }
        return true;
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.hasShield()) {
            Entity entity = source.m_7640_();
            return !(entity instanceof Projectile) ? super.m_6469_(source, amount) : false;
        }
        return super.m_6469_(source, amount);
    }

    private boolean hasShield() {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.OFFHAND);
        return itemstack.m_41720_() instanceof ShieldItem;
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public void m_7895_(int wave, boolean unused) {
        if (this.f_19796_.m_188501_() < 0.25f) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42740_));
        }
    }

    public boolean m_7490_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return RaidedRegistry.INCINERATOR.getAmbient();
    }

    protected SoundEvent m_5592_() {
        return RaidedRegistry.INCINERATOR.getDeath();
    }

    protected SoundEvent m_7975_(DamageSource p_33306_) {
        return RaidedRegistry.INCINERATOR.getHurt();
    }

    public SoundEvent m_7930_() {
        return RaidedRegistry.INCINERATOR.getCelebrate();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData spawngroupdata = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_21553_(this.f_19796_.m_188501_() < 0.55f * difficultyInstance.m_19057_());
        this.setCombatGoal();
        return spawngroupdata;
    }

    private void setCombatGoal() {
        ItemStack itemstack = this.m_21205_();
        if (itemstack.m_41619_()) {
            this.f_21345_.m_25363_((Goal)this.incineratorMeleeGoal);
            this.f_21345_.m_25352_(1, (Goal)this.rangedAttackGoal);
            this.setThrowing(false);
            this.animationPlay = false;
            this.animationTimer = 0;
        } else {
            this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.incineratorMeleeGoal);
        }
    }

    public void m_8119_() {
        if (this.m_21223_() < this.m_21233_() * 0.75f && this.switchHealth == 0) {
            if (this.getWeaponType() == 0) {
                if (this.f_19796_.m_188503_(4) == 0) {
                    this.setWeaponType(2);
                } else {
                    this.setWeaponType(1);
                }
            }
            this.setCombatGoal();
            this.switchHealth = 1;
        }
        if (this.m_21223_() > this.m_21233_() * 0.75f && this.switchHealth == 1) {
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            this.setCombatGoal();
            this.switchHealth = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setCombatGoal();
                this.animationPlay = false;
            }
        }
        super.m_8119_();
    }

    static class IncineratorMeleeAttackGoal
    extends MeleeAttackGoal {
        public IncineratorMeleeAttackGoal(Incinerator inquisitor) {
            super((PathfinderMob)inquisitor, 1.0, false);
        }
    }
}

