/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.raided.registry.RaidRegHelper;
import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RaidedDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_236039_(event.includeServer(), (DataProvider)new Loots(generator));
        }
        if (event.includeClient()) {
            generator.m_236039_(event.includeClient(), (DataProvider)new Language(generator));
            generator.m_236039_(event.includeClient(), (DataProvider)new ItemModels(generator, helper));
            generator.m_236039_(event.includeClient(), (DataProvider)new SoundProvider(generator, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(RaidedLootTables::new, (Object)LootContextParamSets.f_81415_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)table));
        }

        public static class RaidedLootTables
        extends EntityLoot {
            protected void addTables() {
                this.m_124371_(RaidedRegistry.INQUISITOR.getEntityType(), LootTable.m_79147_());
                this.m_124371_(RaidedRegistry.INCINERATOR.getEntityType(), LootTable.m_79147_());
                this.m_124371_(RaidedRegistry.SAVAGER.getEntityType(), LootTable.m_79147_());
                this.m_124371_(RaidedRegistry.NECROMANCER.getEntityType(), LootTable.m_79147_());
                this.m_124371_(RaidedRegistry.ELECTROMANCER.getEntityType(), LootTable.m_79147_());
            }

            protected Iterable<EntityType<?>> getKnownEntities() {
                Stream<EntityType> entityTypeStream = RaidedRegistry.ENTITY_TYPES.getEntries().stream().map(RegistryObject::get);
                return entityTypeStream::iterator;
            }
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "raided", "en_us");
        }

        protected void addTranslations() {
            this.addHelper(RaidedRegistry.INQUISITOR, "Inquisitor");
            this.addHelper(RaidedRegistry.INCINERATOR, "Incinerator");
            this.addHelper(RaidedRegistry.SAVAGER, "Savager");
            this.addHelper(RaidedRegistry.NECROMANCER, "Necromancer");
            this.addHelper(RaidedRegistry.ELECTROMANCER, "Electromancer");
            this.addSubtitle((SoundEvent)RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.get(), "Electromancer prepares conversion");
        }

        private void addHelper(RaidRegHelper helper, String name) {
            this.add(helper.getEntityType(), name);
            this.addItem((Supplier)helper.getSpawnEgg(), name + " Spawn Egg");
            this.addSubtitle(helper.getAmbient(), name + " mutters");
            this.addSubtitle(helper.getDeath(), name + " dies");
            this.addSubtitle(helper.getHurt(), name + " hurts");
            this.addSubtitle(helper.getCelebrate(), name + " cheers");
            if (helper.getCasting() != null) {
                this.addSubtitle(helper.getCasting(), name + " casts spell");
            }
        }

        public void addSubtitle(SoundEvent sound, String name) {
            String path = "raided.subtitle." + sound.m_11660_().m_135815_();
            this.add(path, name);
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "raided", helper);
        }

        protected void registerModels() {
            for (RegistryObject item : RaidedRegistry.ITEMS.getEntries()) {
                if (!(item.get() instanceof SpawnEggItem)) continue;
                this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/template_spawn_egg"));
            }
        }
    }

    private static class SoundProvider
    extends SoundDefinitionsProvider {
        public SoundProvider(DataGenerator generator, ExistingFileHelper helper) {
            super(generator, "raided", helper);
        }

        public void registerSounds() {
            this.addHelper(RaidedRegistry.INQUISITOR);
            this.addHelper(RaidedRegistry.INCINERATOR);
            this.addHelper(RaidedRegistry.SAVAGER);
            this.addHelper(RaidedRegistry.NECROMANCER);
            this.addHelper(RaidedRegistry.ELECTROMANCER);
            this.add((SoundEvent)RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.get(), SoundProvider.definition().with(SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/prepare_wololo"))).subtitle(this.modSubtitle(RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.getId())));
        }

        private void addHelper(RaidRegHelper helper) {
            this.add(helper.getAmbient(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle1")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle2")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle3")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle4"))}).subtitle(this.modSubtitle(helper.getAmbient().m_11660_())));
            this.add(helper.getDeath(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/death1")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/death2"))}).subtitle(this.modSubtitle(helper.getDeath().m_11660_())));
            this.add(helper.getHurt(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/hurt1")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/hurt2"))}).subtitle(this.modSubtitle(helper.getDeath().m_11660_())));
            this.add(helper.getCelebrate(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/celebrate")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle1")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle2"))}).subtitle(this.modSubtitle(helper.getCelebrate().m_11660_())));
            if (helper.getCasting() != null) {
                this.add(helper.getCasting(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/cast1")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/cast2"))}).subtitle(this.modSubtitle(helper.getCasting().m_11660_())));
            }
        }

        public String modSubtitle(ResourceLocation id) {
            return "raided.subtitle." + id.m_135815_();
        }
    }
}

