/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.quark.content.client.hax.PseudoAccessorItemStack;
import vazkii.quark.content.client.resources.AttributeSlot;
import vazkii.quark.content.client.tooltip.AttributeTooltips;
import vazkii.quark.content.management.module.ItemSharingModule;
import vazkii.quark.content.tools.module.AncientTomesModule;
import vazkii.quark.content.tweaks.module.GoldToolsHaveFortuneModule;

@Mixin(value={ItemStack.class})
public class ItemStackMixin
implements PseudoAccessorItemStack {
    @Unique
    private Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> capturedAttributes = new HashMap<AttributeSlot, Multimap<Attribute, AttributeModifier>>();

    @ModifyReturnValue(method={"getDisplayName"}, at={@At(value="RETURN")})
    private Component getHoverName(Component prev) {
        return ItemSharingModule.createStackComponent((ItemStack)this, (MutableComponent)prev);
    }

    @ModifyReturnValue(method={"getRarity"}, at={@At(value="RETURN")})
    private Rarity getRarity(Rarity prev) {
        return AncientTomesModule.shiftRarity((ItemStack)this, prev);
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="HEAD")})
    private void hasTagIfBaked(Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir, @Share(value="removedEnchantments") LocalBooleanRef ref) {
        ItemStack self = (ItemStack)this;
        if (!self.m_41782_() && GoldToolsHaveFortuneModule.shouldShowEnchantments(self)) {
            ref.set(true);
            self.m_41751_(new CompoundTag());
        }
    }

    @ModifyExpressionValue(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hasTag()Z", ordinal=0)})
    private boolean hasTagIfBaked(boolean hasTag, @Share(value="removedEnchantments") LocalBooleanRef ref) {
        return hasTag || ref.get();
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")})
    private void removeTagIfBaked(Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir, @Share(value="removedEnchantments") LocalBooleanRef ref) {
        ItemStack self = (ItemStack)this;
        if (ref.get()) {
            self.m_41751_(null);
        }
    }

    @ModifyArg(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;appendEnchantmentNames(Ljava/util/List;Lnet/minecraft/nbt/ListTag;)V"))
    private ListTag hideSmallerEnchantments(ListTag tag) {
        return GoldToolsHaveFortuneModule.hideSmallerEnchantments((ItemStack)this, tag);
    }

    @ModifyArg(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;appendEnchantmentNames(Ljava/util/List;Lnet/minecraft/nbt/ListTag;)V"))
    private List<Component> appendEnchantmentNames(List<Component> components) {
        GoldToolsHaveFortuneModule.fakeEnchantmentTooltip((ItemStack)this, components);
        return components;
    }

    @Override
    public Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> quark$getCapturedAttributes() {
        return this.capturedAttributes;
    }

    @Override
    public void quark$capturePotionAttributes(List<Pair<Attribute, AttributeModifier>> attributes) {
        LinkedHashMultimap attributeContainer = LinkedHashMultimap.create();
        for (Pair<Attribute, AttributeModifier> pair : attributes) {
            attributeContainer.put((Object)((Attribute)pair.getFirst()), (Object)((AttributeModifier)pair.getSecond()));
        }
        this.capturedAttributes.put(AttributeSlot.POTION, (Multimap<Attribute, AttributeModifier>)attributeContainer);
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="HEAD")})
    private void clearCapturedTooltip(Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir) {
        this.capturedAttributes = new HashMap<AttributeSlot, Multimap<Attribute, AttributeModifier>>();
    }

    @ModifyReceiver(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/Multimap;isEmpty()Z", remap=false)})
    private Multimap<Attribute, AttributeModifier> overrideAttributeTooltips(Multimap<Attribute, AttributeModifier> attributes, @Local EquipmentSlot slot) {
        if (AttributeTooltips.shouldHideAttributes()) {
            this.capturedAttributes.put(AttributeSlot.fromCanonicalSlot(slot), (Multimap<Attribute, AttributeModifier>)LinkedHashMultimap.create(attributes));
            return ImmutableMultimap.of();
        }
        return attributes;
    }
}

