/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.item.QuarkMusicDiscItem;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class EndermoshMusicDiscModule
extends QuarkModule {
    @Config
    private boolean playEndermoshDuringEnderdragonFight = false;
    @Config
    private boolean addToEndCityLoot = true;
    @Config
    private int lootWeight = 5;
    @Config
    private int lootQuality = 1;
    @Hint
    public static QuarkMusicDiscItem endermosh;
    @OnlyIn(value=Dist.CLIENT)
    private boolean isFightingDragon;
    @OnlyIn(value=Dist.CLIENT)
    private int delay;
    @OnlyIn(value=Dist.CLIENT)
    private SimpleSoundInstance sound;

    @Override
    public void register() {
        endermosh = new QuarkMusicDiscItem(14, () -> QuarkSounds.MUSIC_ENDERMOSH, "endermosh", this, 3783);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation res;
        if (this.addToEndCityLoot && (res = event.getName()).equals((Object)BuiltInLootTables.f_78741_)) {
            LootPoolEntryContainer entry = LootItem.m_79579_((ItemLike)endermosh).m_79707_(this.lootWeight).m_79711_(this.lootQuality).m_7512_();
            MiscUtil.addToLootTable(event.getTable(), entry);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.playEndermoshDuringEnderdragonFight) {
            boolean wasFightingDragon = this.isFightingDragon;
            Minecraft mc = Minecraft.m_91087_();
            this.isFightingDragon = mc.f_91073_ != null && mc.f_91073_.m_46472_().m_135782_().equals((Object)LevelStem.f_63973_.m_135782_()) && mc.f_91065_.m_93090_().m_93713_();
            int targetDelay = 50;
            if (this.isFightingDragon) {
                if (this.delay == 50) {
                    this.sound = SimpleSoundInstance.m_119745_((SoundEvent)QuarkSounds.MUSIC_ENDERMOSH);
                    mc.m_91106_().m_120369_((SoundInstance)this.sound, 0);
                    mc.f_91065_.m_93055_((Component)endermosh.m_43050_());
                }
                double x = mc.f_91074_.m_20185_();
                double z = mc.f_91074_.m_20189_();
                if (mc.f_91080_ == null && x * x + z * z < 3000.0) {
                    ++this.delay;
                }
            } else if (wasFightingDragon && this.sound != null) {
                mc.m_91106_().m_120399_((SoundInstance)this.sound);
                this.delay = 0;
                this.sound = null;
            }
        }
    }
}

