/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config;

import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import vazkii.quark.base.module.config.IConfigBuilder;
import vazkii.quark.base.module.config.IConfigCallback;

public class QuarkConfigBuilder
implements IConfigBuilder {
    private final ForgeConfigSpec.Builder parent;
    private final IConfigCallback callback;
    private Stack<String> layers = new Stack();
    private String currComment = "";

    public QuarkConfigBuilder(ForgeConfigSpec.Builder parent, IConfigCallback callback) {
        this.parent = parent;
        this.callback = callback;
    }

    @Override
    public <T> ForgeConfigSpec configure(Function<IConfigBuilder, T> func) {
        return (ForgeConfigSpec)this.parent.configure(b -> func.apply(this)).getRight();
    }

    @Override
    public void push(String s, Object holderObject) {
        this.layers.push(s);
        this.parent.push(s);
        this.callback.push(s, this.currComment, holderObject);
        this.currComment = "";
    }

    @Override
    public void pop() {
        this.layers.pop();
        this.parent.pop();
        this.callback.pop();
    }

    @Override
    public void comment(String s) {
        this.currComment = this.currComment + s;
    }

    @Override
    public ForgeConfigSpec.ConfigValue<List<?>> defineList(String name, List<?> default_, Supplier<List<?>> getter, Predicate<Object> predicate) {
        this.beforeDefine();
        ForgeConfigSpec.ConfigValue value = this.parent.defineList(name, default_, predicate);
        this.onDefine(value, default_, getter, predicate);
        return value;
    }

    @Override
    public ForgeConfigSpec.ConfigValue<?> defineObj(String name, Object default_, Supplier<Object> getter, Predicate<Object> predicate) {
        if (default_ == null) {
            throw new RuntimeException("Can't define object " + name + " with null default @ " + this.layers.toString());
        }
        this.beforeDefine();
        ForgeConfigSpec.ConfigValue value = this.parent.define(name, default_, predicate);
        this.onDefine(value, default_, getter, predicate);
        return value;
    }

    @Override
    public ForgeConfigSpec.ConfigValue<Boolean> defineBool(String name, Supplier<Boolean> getter, boolean default_) {
        this.beforeDefine();
        ForgeConfigSpec.BooleanValue value = this.parent.define(name, default_);
        this.onDefine((ForgeConfigSpec.ConfigValue)value, default_, getter, o -> true);
        return value;
    }

    @Override
    public ForgeConfigSpec.ConfigValue<Integer> defineInt(String name, Supplier<Integer> getter, int default_) {
        this.beforeDefine();
        ForgeConfigSpec.ConfigValue value = this.parent.define(name, (Object)default_);
        this.onDefine(value, default_, getter, o -> true);
        return value;
    }

    @Override
    public ForgeConfigSpec.ConfigValue<Double> defineDouble(String name, Supplier<Double> getter, double default_) {
        this.beforeDefine();
        ForgeConfigSpec.ConfigValue value = this.parent.define(name, (Object)default_);
        this.onDefine(value, default_, getter, o -> true);
        return value;
    }

    private void beforeDefine() {
        if (this.currComment.length() > 0) {
            this.parent.comment(this.currComment);
        }
    }

    private <T> void onDefine(ForgeConfigSpec.ConfigValue<T> value, T default_, Supplier<T> getter, Predicate<Object> predicate) {
        this.callback.addEntry(value, default_, getter, this.currComment, predicate);
        this.currComment = "";
    }
}

