/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.TriPredicate;
import vazkii.patchouli.common.multiblock.StateMatcher;

public class StringStateMatcher {
    public static IStateMatcher fromString(String s) throws CommandSyntaxException {
        if ((s = s.trim()).equals("ANY")) {
            return StateMatcher.ANY;
        }
        if (s.equals("AIR")) {
            return StateMatcher.AIR;
        }
        return (IStateMatcher)BlockStateParser.m_234724_((Registry)Registry.f_122824_, (String)s, (boolean)true).map(blockResult -> new ExactMatcher(blockResult.f_234748_(), blockResult.f_234749_()), tagResult -> new TagMatcher((HolderSet<Block>)tagResult.f_234762_(), tagResult.f_234763_()));
    }

    private static class TagMatcher
    implements IStateMatcher {
        private final HolderSet<Block> tag;
        private final Map<String, String> props;

        private TagMatcher(HolderSet<Block> tag, Map<String, String> props) {
            this.tag = tag;
            this.props = props;
        }

        @Override
        public BlockState getDisplayedState(long ticks) {
            if (this.tag.m_203632_() == 0) {
                return Blocks.f_50752_.m_49966_();
            }
            int idx = (int)(ticks / 20L % (long)this.tag.m_203632_());
            return ((Block)this.tag.m_203662_(idx).m_203334_()).m_49966_();
        }

        @Override
        public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
            return (w, p, s) -> s.m_204341_(this.tag) && this.checkProps((BlockState)s);
        }

        private boolean checkProps(BlockState state) {
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                Property prop = state.m_60734_().m_49965_().m_61081_(entry.getKey());
                if (prop == null) {
                    return false;
                }
                Comparable value = prop.m_6215_(entry.getValue()).orElse(null);
                if (value == null) {
                    return false;
                }
                if (state.m_61143_(prop).equals(value)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagMatcher that = (TagMatcher)o;
            return Objects.equals(this.tag, that.tag) && Objects.equals(this.props, that.props);
        }

        public int hashCode() {
            return Objects.hash(this.tag, this.props);
        }
    }

    private static class ExactMatcher
    implements IStateMatcher {
        private final BlockState state;
        private final Map<Property<?>, Comparable<?>> props;

        private ExactMatcher(BlockState state, Map<Property<?>, Comparable<?>> props) {
            this.state = state;
            this.props = props;
        }

        @Override
        public BlockState getDisplayedState(long ticks) {
            return this.state;
        }

        @Override
        public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
            return (w, p, s) -> this.state.m_60734_() == s.m_60734_() && this.checkProps((BlockState)s);
        }

        private boolean checkProps(BlockState state) {
            for (Map.Entry<Property<?>, Comparable<?>> e : this.props.entrySet()) {
                if (state.m_61143_(e.getKey()).equals(e.getValue())) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExactMatcher that = (ExactMatcher)o;
            return Objects.equals(this.state, that.state) && Objects.equals(this.props, that.props);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.props);
        }
    }
}

