/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.config.ClientConfig;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RowCountRenderer {
    private static final ResourceLocation TINY_NUMBERS_LOCATION = new ResourceLocation("overflowingbars", "textures/font/tiny_numbers.png");

    public static void drawBarRowCount(PoseStack poseStack, int posX, int posY, int barValue, boolean left, Font font) {
        RowCountRenderer.drawBarRowCount(poseStack, posX, posY, barValue, left, 20, font);
    }

    public static void drawBarRowCount(PoseStack poseStack, int posX, int posY, int barValue, boolean left, int maxRowCount, Font font) {
        if (barValue <= 0 || maxRowCount <= 0) {
            return;
        }
        float rowCount = (float)barValue / (float)maxRowCount;
        ClientConfig config = (ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class);
        if (!config.rowCount.alwaysRenderRowCount && rowCount <= 1.0f) {
            return;
        }
        int renderCount = config.rowCount.countFullRowsOnly ? Mth.m_14143_((float)rowCount) : Mth.m_14167_((float)rowCount);
        int textColor = config.rowCount.rowCountColor.m_126665_();
        if (config.rowCount.forceFontRenderer) {
            Object text = String.valueOf(renderCount);
            if (config.rowCount.rowCountX) {
                text = (String)text + "x";
            }
            if (left) {
                posX -= font.m_92895_((String)text);
            }
            RowCountRenderer.drawBorderedText(poseStack, posX, posY + 1, (String)text, textColor, 255, font);
        } else {
            if (renderCount > 9) {
                return;
            }
            float red = (float)(textColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(textColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(textColor >> 0 & 0xFF) / 255.0f;
            if (left) {
                posX -= config.rowCount.rowCountX ? 7 : 3;
            }
            RowCountRenderer.drawTinyRowCount(poseStack, posX, posY + 2, renderCount, 1.0f, red, green, blue);
        }
    }

    private static void drawTinyRowCount(PoseStack poseStack, int posX, int posY, int count, float alpha, float red, float green, float blue) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TINY_NUMBERS_LOCATION);
        RowCountRenderer.drawBorderedSprite(poseStack, 3, 5, posX, posY, 5 * count, 0, red, green, blue, alpha);
        if (((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).rowCount.rowCountX) {
            RowCountRenderer.drawBorderedSprite(poseStack, 3, 5, posX + 4, posY, 0, 7, red, green, blue, alpha);
        }
    }

    private static void drawBorderedSprite(PoseStack poseStack, int width, int height, int posX, int posY, int textureX, int textureY, float red, float green, float blue, float alpha) {
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(posX - 1), (int)posY, (float)textureX, (float)textureY, (int)width, (int)height, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(posX + 1), (int)posY, (float)textureX, (float)textureY, (int)width, (int)height, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)posX, (int)(posY - 1), (float)textureX, (float)textureY, (int)width, (int)height, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)posX, (int)(posY + 1), (float)textureX, (float)textureY, (int)width, (int)height, (int)256, (int)256);
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)posX, (int)posY, (float)textureX, (float)textureY, (int)width, (int)height, (int)256, (int)256);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawBorderedText(PoseStack poseStack, int posX, int posY, String text, int color, int alpha, Font font) {
        font.m_92883_(poseStack, text, (float)(posX - 1), (float)posY, alpha << 24);
        font.m_92883_(poseStack, text, (float)(posX + 1), (float)posY, alpha << 24);
        font.m_92883_(poseStack, text, (float)posX, (float)(posY - 1), alpha << 24);
        font.m_92883_(poseStack, text, (float)posX, (float)(posY + 1), alpha << 24);
        font.m_92883_(poseStack, text, (float)posX, (float)posY, color & 0xFFFFFF | alpha << 24);
    }
}

