/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.client.handler.BarOverlayRenderer;
import fuzs.overflowingbars.config.ClientConfig;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class ArmorBarRenderer {
    public static void renderArmorBar(PoseStack poseStack, int posX, int posY, Player player, ProfilerFiller profiler, boolean unmodified) {
        profiler.m_6180_("armor");
        ClientConfig.ArmorRowConfig config = ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).armor;
        int armorPoints = player.m_21230_();
        ArmorBarRenderer.renderArmorBar(poseStack, posX, posY, 18, armorPoints, true, unmodified, config);
        profiler.m_7238_();
    }

    public static void renderToughnessBar(PoseStack poseStack, int posX, int posY, Player player, ProfilerFiller profiler, boolean left, boolean unmodified) {
        profiler.m_6180_("toughness");
        ClientConfig.ToughnessRowConfig config = ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).toughness;
        int armorPoints = Mth.m_14107_((double)player.m_21133_(Attributes.f_22285_));
        ArmorBarRenderer.renderArmorBar(poseStack, posX, posY, left ? 9 : 0, armorPoints, left, unmodified, config);
        profiler.m_7238_();
    }

    public static void renderArmorBar(PoseStack poseStack, int posX, int posY, int vOffset, int armorPoints, boolean left, boolean unmodified, ClientConfig.ArmorRowConfig config) {
        if (armorPoints <= 0) {
            return;
        }
        BarOverlayRenderer.resetRenderState(BarOverlayRenderer.OVERFLOWING_ICONS_LOCATION);
        boolean inverse = !unmodified && config.inverseColoring;
        boolean skip = !unmodified && config.skipEmptyArmorPoints;
        int lastRowArmorPoints = 0;
        if (!unmodified && (config.colorizeFirstRow || armorPoints > 20)) {
            lastRowArmorPoints = (armorPoints - 1) % 20 + 1;
        }
        for (int currentArmorPoint = 0; currentArmorPoint < 10; ++currentArmorPoint) {
            int startX = posX + (left ? currentArmorPoint * 8 : -currentArmorPoint * 8 - 9);
            if (currentArmorPoint * 2 + 1 < lastRowArmorPoints) {
                GuiComponent.m_93133_((PoseStack)poseStack, (int)startX, (int)posY, (float)(inverse ? 18.0f : 36.0f), (float)vOffset, (int)9, (int)9, (int)256, (int)256);
                continue;
            }
            if (currentArmorPoint * 2 + 1 == lastRowArmorPoints) {
                if (armorPoints > 20) {
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)startX, (int)posY, (float)(inverse ? 54.0f : 27.0f), (float)vOffset, (int)9, (int)9, (int)256, (int)256);
                    continue;
                }
                GuiComponent.m_93133_((PoseStack)poseStack, (int)startX, (int)posY, (float)(inverse ? 9.0f : 45.0f), (float)vOffset, (int)9, (int)9, (int)256, (int)256);
                continue;
            }
            if (currentArmorPoint * 2 + 1 < armorPoints) {
                GuiComponent.m_93133_((PoseStack)poseStack, (int)startX, (int)posY, (float)(inverse ? 36.0f : 18.0f), (float)vOffset, (int)9, (int)9, (int)256, (int)256);
                continue;
            }
            if (currentArmorPoint * 2 + 1 == armorPoints) {
                GuiComponent.m_93133_((PoseStack)poseStack, (int)startX, (int)posY, (float)(inverse ? 45.0f : 9.0f), (float)vOffset, (int)9, (int)9, (int)256, (int)256);
                continue;
            }
            if (skip || currentArmorPoint * 2 + 1 <= armorPoints) continue;
            GuiComponent.m_93133_((PoseStack)poseStack, (int)startX, (int)posY, (float)0.0f, (float)vOffset, (int)9, (int)9, (int)256, (int)256);
        }
    }
}

