/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.worldgen;

import com.mojang.serialization.Codec;
import com.mrbysco.oreberriesreplanted.block.OreBerryBushBlock;
import com.mrbysco.oreberriesreplanted.worldgen.OreBerryBushFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class OreBerryBushFeature
extends Feature<OreBerryBushFeatureConfig> {
    public OreBerryBushFeature(Codec<OreBerryBushFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<OreBerryBushFeatureConfig> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        ChunkGenerator generator = context.m_159775_();
        int density = 1;
        Block block = ((OreBerryBushFeatureConfig)context.m_159778_()).state.m_60734_();
        if (block instanceof OreBerryBushBlock) {
            OreBerryBushBlock block2 = (OreBerryBushBlock)block;
            density = block2.getDensity();
        }
        OreBerryBushFeatureConfig config = (OreBerryBushFeatureConfig)context.m_159778_();
        for (int i = 0; i < density; ++i) {
            BlockPos adequateLocation = this.findAdequateLocation((LevelAccessor)level, pos, generator, config);
            if (adequateLocation == null) continue;
            int type = rand.m_188503_(config.chance);
            if (type == 11) {
                this.generateMediumNode((LevelAccessor)level, rand, adequateLocation, config);
                continue;
            }
            if (type >= 5) {
                this.generateSmallNode((LevelAccessor)level, rand, adequateLocation, config);
                continue;
            }
            this.generateTinyNode((LevelAccessor)level, rand, adequateLocation, config);
        }
        return true;
    }

    protected BlockPos findAdequateLocation(LevelAccessor world, BlockPos blockPos, ChunkGenerator generator, OreBerryBushFeatureConfig config) {
        int searchRadius = 16;
        int currentCheck = 0;
        BlockPos pos = new BlockPos((Vec3i)blockPos);
        do {
            if (world.m_46859_(pos) && !world.m_46859_(pos.m_7494_())) {
                return pos.m_7494_();
            }
            pos = pos.m_7494_();
        } while (++currentCheck < searchRadius);
        currentCheck = 0;
        pos = new BlockPos((Vec3i)blockPos);
        do {
            if (world.m_46859_(pos) && !world.m_46859_(pos.m_7495_())) {
                return pos.m_7495_();
            }
            pos = pos.m_7495_();
        } while (++currentCheck < searchRadius);
        return null;
    }

    public void generateMediumNode(LevelAccessor world, RandomSource random, BlockPos pos, OreBerryBushFeatureConfig config) {
        for (int xPos = -1; xPos <= 1; ++xPos) {
            for (int yPos = -1; yPos <= 1; ++yPos) {
                for (int zPos = -1; zPos <= 1; ++zPos) {
                    if (random.m_188503_(4) != 0) continue;
                    this.generateBerryBlock(world, pos.m_7918_(xPos, yPos, zPos), random, config);
                }
            }
        }
        this.generateSmallNode(world, random, pos, config);
    }

    public void generateSmallNode(LevelAccessor world, RandomSource random, BlockPos pos, OreBerryBushFeatureConfig config) {
        this.generateBerryBlock(world, pos, random, config);
        if (random.m_188499_()) {
            this.generateBerryBlock(world, pos.m_122029_(), random, config);
        }
        if (random.m_188499_()) {
            this.generateBerryBlock(world, pos.m_122024_(), random, config);
        }
        if (random.m_188499_()) {
            this.generateBerryBlock(world, pos.m_122019_(), random, config);
        }
        if (random.m_188499_()) {
            this.generateBerryBlock(world, pos.m_122012_(), random, config);
        }
        if (random.m_188503_(4) != 0) {
            this.generateBerryBlock(world, pos.m_7494_(), random, config);
        }
    }

    public void generateTinyNode(LevelAccessor world, RandomSource random, BlockPos pos, OreBerryBushFeatureConfig config) {
        this.generateBerryBlock(world, pos, random, config);
        if (random.m_188503_(4) == 0) {
            this.generateBerryBlock(world, pos.m_122029_(), random, config);
        }
        if (random.m_188503_(4) == 0) {
            this.generateBerryBlock(world, pos.m_122024_(), random, config);
        }
        if (random.m_188503_(4) == 0) {
            this.generateBerryBlock(world, pos.m_122019_(), random, config);
        }
        if (random.m_188503_(4) == 0) {
            this.generateBerryBlock(world, pos.m_122012_(), random, config);
        }
        if (random.m_188503_(16) < 7) {
            this.generateBerryBlock(world, pos.m_7494_(), random, config);
        }
    }

    private void generateBerryBlock(LevelAccessor world, BlockPos pos, RandomSource random, OreBerryBushFeatureConfig config) {
        BlockState state = world.m_8055_(pos);
        if (!(world.m_46859_(pos.m_7494_()) && world.m_46859_(pos.m_7495_()) || !this.isCaveAir(world, pos) && !config.target.m_213865_(state, random))) {
            world.m_7731_(pos, config.state, 2);
        }
    }

    public boolean isCaveAir(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_() == Blocks.f_50627_;
    }
}

