/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRecipes;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class VatRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final Fluid fluid;
    protected final Ingredient result;
    protected final int evaporationTime;
    protected final int evaporationAmount;
    protected final float min;
    protected final float max;

    public VatRecipe(ResourceLocation location, String group, Ingredient ingredient, Fluid fluid, Ingredient resultStack, int time, int amount, float min, float max) {
        this.id = location;
        this.group = group;
        this.ingredient = ingredient;
        this.fluid = fluid;
        this.result = resultStack;
        this.evaporationTime = time;
        this.evaporationAmount = amount;
        this.min = min;
        this.max = max;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Ingredient getResultIngredient() {
        return this.result;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return this.ingredient.test(inventory.m_8020_(0));
    }

    public ItemStack m_5874_(Container inventory) {
        return this.m_8043_().m_41777_();
    }

    public boolean m_8004_(int x, int y) {
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public ItemStack m_8043_() {
        return this.result.m_43908_()[0];
    }

    public String m_6076_() {
        return this.group;
    }

    public int getEvaporationTime() {
        return this.evaporationTime;
    }

    public int getEvaporationAmount() {
        return this.evaporationAmount;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)OreBerryRecipes.VAT_RECIPE_TYPE.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)OreBerryRegistry.OAK_VAT.get());
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)OreBerryRecipes.VAT_SERIALIZER.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<VatRecipe> {
        public VatRecipe fromJson(ResourceLocation location, JsonObject jsonObject) {
            String group = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            Object jsonelement = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            String s1 = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"fluid");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            Fluid fluid = (Fluid)Registry.f_122822_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Fluid: " + s1 + " does not exist"));
            int evaporationTime = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"evaporationtime", (int)100);
            int evaporationAmount = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"evaporationamount", (int)100);
            float min = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"min", (float)1.5f);
            float max = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"max", (float)2.0f);
            if (!jsonObject.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            jsonelement = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"result") ? GsonHelper.m_13933_((JsonObject)jsonObject, (String)"result") : GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result");
            Ingredient result = Ingredient.m_43917_((JsonElement)jsonelement);
            if (result.m_43947_()) {
                throw new JsonSyntaxException("Missing result: ingredient has no matching stacks");
            }
            return new VatRecipe(location, group, ingredient, fluid, result, evaporationTime, evaporationAmount, min, max);
        }

        @Nullable
        public VatRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ResourceLocation fluidLocation = buffer.m_130281_();
            Fluid fluid = (Fluid)Registry.f_122822_.m_6612_(fluidLocation).orElseThrow(() -> new IllegalStateException("Fluid: " + fluidLocation + " does not exist"));
            Ingredient result = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int evaporationTime = buffer.m_130242_();
            int evaporationAmount = buffer.m_130242_();
            float min = buffer.readFloat();
            float max = buffer.readFloat();
            return new VatRecipe(location, group, ingredient, fluid, result, evaporationTime, evaporationAmount, min, max);
        }

        public void toNetwork(FriendlyByteBuf buffer, VatRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            recipe.getIngredient().m_43923_(buffer);
            buffer.m_130085_(ForgeRegistries.FLUIDS.getKey((Object)recipe.fluid));
            recipe.getResultIngredient().m_43923_(buffer);
            buffer.m_130130_(recipe.getEvaporationTime());
            buffer.m_130130_(recipe.getEvaporationAmount());
            buffer.writeFloat(recipe.getMin());
            buffer.writeFloat(recipe.getMax());
        }
    }
}

