/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.compat.jei;

import com.mrbysco.oreberriesreplanted.OreberriesReplanted;
import com.mrbysco.oreberriesreplanted.recipes.VatRecipe;
import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class VatRecipeValidator {
    private static final int INVALID_COUNT = -1;
    private final IRecipeCategory<VatRecipe> recipeCategory;

    public VatRecipeValidator(IRecipeCategory<VatRecipe> recipeCategory) {
        this.recipeCategory = recipeCategory;
    }

    public boolean isRecipeValid(VatRecipe recipe) {
        return this.hasValidInputsAndOutputs(recipe);
    }

    public boolean isRecipeHandled(VatRecipe recipe) {
        return this.recipeCategory.isHandled((Object)recipe);
    }

    private boolean hasValidInputsAndOutputs(VatRecipe recipe) {
        if (recipe.m_5598_()) {
            return true;
        }
        ItemStack recipeOutput = recipe.m_8043_();
        if (recipeOutput == null || recipeOutput.m_41619_()) {
            OreberriesReplanted.LOGGER.error("Recipe has no output. {}", (Object)recipe.m_6423_());
            return false;
        }
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        if (ingredients == null) {
            OreberriesReplanted.LOGGER.error("Recipe has no input Ingredients. {}", (Object)recipe.m_6423_());
            return false;
        }
        int inputCount = VatRecipeValidator.getInputCount(ingredients);
        if (inputCount == -1) {
            return false;
        }
        if (inputCount > 1) {
            OreberriesReplanted.LOGGER.error("Recipe has too many inputs. {}", (Object)recipe.m_6423_());
            return false;
        }
        if (inputCount == 0) {
            OreberriesReplanted.LOGGER.error("Recipe has no inputs. {}", (Object)recipe.m_6423_());
            return false;
        }
        return true;
    }

    private static int getInputCount(List<Ingredient> ingredientList) {
        int inputCount = 0;
        for (Ingredient ingredient : ingredientList) {
            ItemStack[] input = ingredient.m_43908_();
            if (input == null) {
                return -1;
            }
            ++inputCount;
        }
        return inputCount;
    }
}

