/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.blockentity;

import com.mrbysco.oreberriesreplanted.recipes.VatRecipe;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRecipes;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class VatBlockEntity
extends BlockEntity {
    public final FluidTank tank = new FluidTank(3200){

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!VatBlockEntity.this.isFluidEqual(resource)) {
                return FluidStack.EMPTY;
            }
            if (action.simulate()) {
                int amount = VatBlockEntity.this.tank.getFluidAmount() - resource.getAmount() < 0 ? VatBlockEntity.this.tank.getFluidAmount() : resource.getAmount();
                return new FluidStack(VatBlockEntity.this.tank.getFluid(), amount);
            }
            return super.drain(resource.getAmount(), action);
        }

        protected void onContentsChanged() {
            VatBlockEntity.this.refreshClient();
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return super.drain(maxDrain, action);
        }

        public boolean isFluidValid(FluidStack stack) {
            for (VatRecipe recipe : VatBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)OreBerryRecipes.VAT_RECIPE_TYPE.get())) {
                if (!stack.getFluid().m_6212_(recipe.getFluid())) continue;
                return true;
            }
            return false;
        }
    };
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    public final ItemStackHandler handler = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 32;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            for (VatRecipe recipe : VatBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)OreBerryRecipes.VAT_RECIPE_TYPE.get())) {
                if (!((Ingredient)recipe.m_7527_().get(0)).test(stack)) continue;
                return true;
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            VatBlockEntity.this.refreshClient();
        }
    };
    private final LazyOptional<IItemHandler> handlerHolder = LazyOptional.of(() -> this.handler);
    protected VatRecipe curRecipe;
    private int evaporateProgress;
    private int evaporateTotalTime;
    private int crushCooldown = -1;

    public VatBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public VatBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)OreBerryRegistry.VAT_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        this.evaporateProgress = tag.m_128451_("evaporateProgress");
        this.evaporateTotalTime = tag.m_128451_("evaporateTotalTime");
        this.crushCooldown = tag.m_128451_("crushCooldown");
        this.handler.deserializeNBT(tag.m_128469_("ItemStackHandler"));
        this.tank.readFromNBT(tag);
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("evaporateProgress", this.evaporateProgress);
        tag.m_128405_("evaporateTotalTime", this.evaporateTotalTime);
        tag.m_128405_("crushCooldown", this.crushCooldown);
        tag.m_128365_("ItemStackHandler", (Tag)this.handler.serializeNBT());
        this.tank.writeToNBT(tag);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, VatBlockEntity vatBlockEntity) {
        VatRecipe irecipe;
        boolean valid;
        if (level.f_46443_) {
            return;
        }
        if (vatBlockEntity.crushCooldown > 0) {
            --vatBlockEntity.crushCooldown;
        }
        if (!vatBlockEntity.tank.isEmpty() && (valid = vatBlockEntity.canEvaporate(irecipe = vatBlockEntity.getRecipe()))) {
            if (vatBlockEntity.evaporateTotalTime == 0) {
                vatBlockEntity.evaporateTotalTime = vatBlockEntity.getMaxEvaporateTime();
                vatBlockEntity.evaporateProgress = 0;
            }
            ++vatBlockEntity.evaporateProgress;
            if (vatBlockEntity.evaporateProgress < vatBlockEntity.evaporateTotalTime) {
                return;
            }
            vatBlockEntity.evaporateProgress = 0;
            vatBlockEntity.evaporateTotalTime = vatBlockEntity.getMaxEvaporateTime();
            vatBlockEntity.evaporateLiquid(irecipe);
            vatBlockEntity.refreshClient();
        }
    }

    protected void evaporateLiquid(VatRecipe recipe) {
        int evaporationAmount = recipe.getEvaporationAmount();
        ItemStack outputStack = this.curRecipe.m_5874_(null);
        this.tank.drain(evaporationAmount, IFluidHandler.FluidAction.EXECUTE);
        BlockPos blockpos = this.m_58899_();
        Containers.m_18992_((Level)this.f_58857_, (double)blockpos.m_123341_(), (double)((double)blockpos.m_123342_() + 0.1), (double)blockpos.m_123343_(), (ItemStack)outputStack);
        this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    protected void refreshClient() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    protected boolean canEvaporate(@Nullable VatRecipe recipe) {
        if (!this.tank.isEmpty() && recipe != null) {
            return this.tank.getFluidAmount() > recipe.getEvaporationAmount();
        }
        return false;
    }

    public void crushBerry() {
        if (!this.isOnCooldown()) {
            ItemStack berryStack = this.handler.getStackInSlot(0);
            VatRecipe rec = this.getRecipe();
            if (rec != null && !berryStack.m_41619_()) {
                int liquidAmount = this.f_58857_.f_46441_.m_188503_((int)(rec.getMax() * 100.0f) - (int)(rec.getMin() * 100.0f)) + (int)(rec.getMin() * 100.0f);
                liquidAmount = (int)Math.round((double)liquidAmount / 10.0) * 10;
                FluidStack stack = new FluidStack(rec.getFluid(), liquidAmount);
                int accepted = this.tank.fill(stack, IFluidHandler.FluidAction.SIMULATE);
                if (accepted > 0) {
                    this.tank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                    berryStack.m_41774_(1);
                }
            }
            this.setCooldown(20);
        }
    }

    public void addBerry(ItemEntity entity) {
        ItemStack itemstack = entity.m_32055_().m_41777_();
        int originalCount = itemstack.m_41613_();
        ItemStack resultStack = this.handler.insertItem(0, itemstack, false);
        if (resultStack.m_41619_()) {
            entity.m_146870_();
        } else {
            entity.m_32045_(resultStack);
        }
        if (originalCount != resultStack.m_41613_()) {
            this.refreshClient();
        }
    }

    protected VatRecipe getRecipe() {
        VatRecipe rec;
        ItemStack input = this.handler.getStackInSlot(0);
        if (input.m_41619_()) {
            FluidStack fluidStack = this.tank.getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                for (VatRecipe recipe : this.f_58857_.m_7465_().m_44013_((RecipeType)OreBerryRecipes.VAT_RECIPE_TYPE.get())) {
                    if (!recipe.getFluid().m_6212_(fluidStack.getFluid())) continue;
                    this.curRecipe = recipe;
                    return this.curRecipe;
                }
            }
            return null;
        }
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.m_6836_(0, input);
        if (this.curRecipe != null && this.curRecipe.m_5818_((Container)inventory, this.f_58857_)) {
            return this.curRecipe;
        }
        this.curRecipe = rec = (VatRecipe)this.f_58857_.m_7465_().m_44015_((RecipeType)OreBerryRecipes.VAT_RECIPE_TYPE.get(), (Container)inventory, this.f_58857_).orElse(null);
        return this.curRecipe;
    }

    protected int getMaxEvaporateTime() {
        VatRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return 100;
        }
        return recipe.getEvaporationTime();
    }

    protected boolean isFluidEqual(FluidStack fluid) {
        return this.isFluidEqual(fluid.getFluid());
    }

    protected boolean isFluidEqual(Fluid fluid) {
        return this.tank.getFluid().getFluid().equals(fluid);
    }

    public void setCooldown(int cooldown) {
        this.crushCooldown = cooldown;
    }

    private boolean isOnCooldown() {
        return this.crushCooldown > 0;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (side != Direction.DOWN && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlerHolder.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handlerHolder.invalidate();
        this.tankHolder.invalidate();
    }
}

