/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.block;

import com.mrbysco.oreberriesreplanted.blockentity.VatBlockEntity;
import com.mrbysco.oreberriesreplanted.mixin.LivingEntityAccessor;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRegistry;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class VatBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)8.0, (double)1.0), Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)8.0, (double)16.0), Block.m_49796_((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)8.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public VatBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        float f = (float)entity.m_20186_() - 0.5f;
        float yPos = (float)pos.m_123342_() - 0.25f;
        if (!entity.m_6144_() && (double)f <= (double)yPos) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (world.m_46467_() % 10L == 0L && blockEntity instanceof VatBlockEntity) {
                VatBlockEntity vat = (VatBlockEntity)blockEntity;
                if (!(!(entity instanceof LivingEntity) || entity instanceof Player && ((Player)entity).m_5833_())) {
                    if (!vat.handler.getStackInSlot(0).m_41619_()) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        ((LivingEntityAccessor)livingEntity).invokeJumpFromGround();
                    }
                    if (!world.f_46443_ && world.f_46441_.m_188503_(8) == 0) {
                        vat.crushBerry();
                    }
                }
                if (!world.f_46443_ && entity instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entity;
                    if (blockEntity instanceof VatBlockEntity) {
                        vat.addBerry(itemEntity);
                    }
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof VatBlockEntity) {
            ItemStack stack = player.m_21120_(hand);
            LazyOptional itemHandler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, blockRayTraceResult.m_82434_());
            itemHandler.ifPresent(handler -> {
                ItemStack remaining;
                if (player.m_6144_()) {
                    ItemStack berryStack = handler.getStackInSlot(0);
                    if (!berryStack.m_41619_()) {
                        Containers.m_18992_((Level)world, (double)player.m_20185_(), (double)(player.m_20186_() + 0.5), (double)player.m_20189_(), (ItemStack)berryStack);
                    }
                } else if (handler.getStackInSlot(0).m_41613_() < handler.getSlotLimit(0) && !(remaining = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.m_41613_())).m_41619_()) {
                    remaining = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                    player.m_21008_(hand, remaining);
                }
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof VatBlockEntity) {
                blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(i));
                    }
                });
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.m_6425_(pos).m_76178_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return VatBlock.createVatTicker(level, entityType, (BlockEntityType<? extends VatBlockEntity>)((BlockEntityType)OreBerryRegistry.VAT_BLOCK_ENTITY.get()));
    }

    protected static <T extends BlockEntity> BlockEntityTicker<T> createVatTicker(Level level, BlockEntityType<T> entityType, BlockEntityType<? extends VatBlockEntity> blockEntityType) {
        return level.f_46443_ ? null : VatBlock.m_152132_(entityType, blockEntityType, VatBlockEntity::serverTick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new VatBlockEntity(pos, state);
    }
}

