/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.merchantmarkers.compat;

import com.anthonyhilyard.iceberg.util.DynamicResourcePack;
import com.anthonyhilyard.merchantmarkers.Loader;
import com.anthonyhilyard.merchantmarkers.MerchantMarkersConfig;
import com.anthonyhilyard.merchantmarkers.render.Markers;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FTBChunksHandler
implements ResourceManagerReloadListener {
    private static FTBChunksHandler INSTANCE = new FTBChunksHandler();
    private static DynamicResourcePack dynamicPack = new DynamicResourcePack("dynamicicons");
    private static Entity currentEntity = null;
    private static Map<Markers.MarkerResource, byte[]> iconCache = new HashMap<Markers.MarkerResource, byte[]>();
    private static BufferedImage iconOverlayImage = null;
    private static BufferedImage numberOverlayImage = null;
    public static final ResourceLocation villagerTexture = new ResourceLocation("ftbchunks", "textures/faces/minecraft/villager.png");
    private static Supplier<InputStream> defaultVillagerResource = null;

    public static void setCurrentEntity(Entity entity) {
        Minecraft minecraft;
        currentEntity = entity;
        if (Markers.shouldShowMarker(entity) && (minecraft = Minecraft.m_91087_()).m_91097_().m_174786_(villagerTexture, null) != null) {
            minecraft.m_18709_(() -> minecraft.m_91097_().m_118513_(villagerTexture));
        }
    }

    public static void clearIconCache() {
        iconCache.clear();
        dynamicPack.clear();
        FTBChunksHandler.setupDynamicIcons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getResizedIcon(Supplier<Markers.MarkerResource> resourceSupplier) {
        ByteArrayInputStream byteArrayInputStream;
        int innerSize;
        Markers.MarkerResource resource = resourceSupplier.get();
        if (resource == null) {
            return Markers.getEmptyInputStream();
        }
        if (iconCache.containsKey(resource)) {
            return new ByteArrayInputStream(iconCache.get(resource));
        }
        int outerSize = innerSize = (int)(32.0 * (Double)MerchantMarkersConfig.getInstance().minimapIconScale.get());
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        BufferedImage newImage = new BufferedImage(outerSize, outerSize, 2);
        Graphics2D graphics = newImage.createGraphics();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (manager.m_213713_(resource.texture()).isEmpty() && Minecraft.m_91087_().m_91097_().m_118506_(resource.texture()) == null) {
            return Markers.getEmptyInputStream();
        }
        if (iconOverlayImage == null) {
            iconOverlayImage = ImageIO.read(((Resource)manager.m_213713_(Markers.ICON_OVERLAY).get()).m_215507_());
        }
        if (numberOverlayImage == null) {
            numberOverlayImage = ImageIO.read(((Resource)manager.m_213713_(Markers.NUMBER_OVERLAY).get()).m_215507_());
        }
        BufferedImage originalImage = ImageIO.read(((Resource)manager.m_213713_(resource.texture()).get()).m_215507_());
        int left = (outerSize - innerSize) / 2;
        int right = (outerSize + innerSize) / 2;
        int top = (outerSize + innerSize) / 2;
        int bottom = (outerSize - innerSize) / 2;
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -newImage.getHeight()));
        graphics.transform(at);
        graphics.drawImage(originalImage, left, top, right, bottom, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
        Markers.renderOverlay(resource, (dx, dy, width, height, sx, sy) -> {
            BufferedImage overlayImage = resource.overlay() == MerchantMarkersConfig.OverlayType.LEVEL ? numberOverlayImage : iconOverlayImage;
            float scale = (float)innerSize / (float)originalImage.getWidth();
            graphics.drawImage(overlayImage, (int)((float)left + (float)dx * scale), (int)((float)top - (float)dy * scale), (int)((float)left + (float)(dx + width) * scale), (int)((float)top - (float)(dy + height) * scale), sx, sy, sx + width, sy + height, null);
        });
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)newImage, "png", os);
            iconCache.put(resource, os.toByteArray());
            byteArrayInputStream = new ByteArrayInputStream(iconCache.get(resource));
        }
        catch (Throwable throwable) {
            try {
                os.close();
                throw throwable;
            }
            catch (Exception e) {
                Loader.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
                iconCache.put(resource, new byte[0]);
                return Markers.getEmptyInputStream();
            }
        }
        os.close();
        return byteArrayInputStream;
    }

    public static void setupDynamicIcons() {
        Minecraft mc = Minecraft.m_91087_();
        ResourceManager manager = mc.m_91098_();
        if (manager instanceof ReloadableResourceManager) {
            CloseableResourceManager closeableResourceManager;
            ReloadableResourceManager reloadableManager = (ReloadableResourceManager)manager;
            if (!reloadableManager.f_203816_.contains(INSTANCE)) {
                reloadableManager.f_203816_.add(0, INSTANCE);
            }
            if (defaultVillagerResource == null) {
                try {
                    for (Resource resource : reloadableManager.m_213829_(villagerTexture)) {
                        if (resource.m_215506_().contentEquals("dynamicicons")) continue;
                        byte[] defaultVillagerBytes = IOUtils.toByteArray((InputStream)resource.m_215507_());
                        defaultVillagerResource = () -> new ByteArrayInputStream(defaultVillagerBytes);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dynamicPack.registerResource(PackType.CLIENT_RESOURCES, villagerTexture, () -> {
                if (currentEntity == null || !Markers.shouldShowMarker(currentEntity)) {
                    return Markers.getEmptyInputStream();
                }
                try {
                    String profession = Markers.getProfessionName(currentEntity);
                    int level = Markers.getProfessionLevel(currentEntity);
                    if (((List)MerchantMarkersConfig.getInstance().professionBlacklist.get()).contains(profession)) {
                        return defaultVillagerResource == null ? Markers.getEmptyInputStream() : defaultVillagerResource.get();
                    }
                    InputStream proxyStream = FTBChunksHandler.getResizedIcon(() -> Markers.getMarkerResource(mc, profession, level));
                    Thread.sleep(5L);
                    if (proxyStream.available() == 0) {
                        return ((Resource)reloadableManager.m_213713_(Markers.getMarkerResource(mc, profession, level).texture()).get()).m_215507_();
                    }
                    return proxyStream;
                }
                catch (Exception e) {
                    return Markers.getEmptyInputStream();
                }
            });
            if (!reloadableManager.m_7536_().anyMatch(pack -> pack.equals(dynamicPack)) && (closeableResourceManager = reloadableManager.f_203815_) instanceof MultiPackResourceManager) {
                MultiPackResourceManager resourceManager = (MultiPackResourceManager)closeableResourceManager;
                try {
                    reloadableManager.f_203815_.close();
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                reloadableManager.f_203815_ = new MultiPackResourceManager(reloadableManager.f_203817_, Stream.concat(resourceManager.m_7536_(), Stream.of(dynamicPack)).toList());
            }
        }
    }

    public void m_6213_(ResourceManager resourceManager) {
        Markers.clearResourceCache();
        FTBChunksHandler.clearIconCache();
    }
}

