/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.crafting.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectIngredient
extends Ingredient {
    @Nullable
    public final Item potionItem;
    public final List<MobEffectInstance> effects;
    public final boolean extraEffects;
    public final boolean higherAmplifier;
    public final boolean higherDuration;

    public EffectIngredient(ItemStack potionStack) {
        this(potionStack.m_41720_(), PotionUtils.m_43547_((ItemStack)potionStack), false, true, true);
    }

    public EffectIngredient(ItemStack potionStack, boolean extraEffects, boolean higherAmplifier, boolean higherDuration) {
        this(potionStack.m_41720_(), PotionUtils.m_43547_((ItemStack)potionStack), extraEffects, higherAmplifier, higherDuration);
    }

    public EffectIngredient(@Nullable Item potionItem, List<MobEffectInstance> effects) {
        this(potionItem, effects, false, true, true);
    }

    public EffectIngredient(@Nullable Item potionItem, List<MobEffectInstance> effects, boolean extraEffects, boolean higherAmplifier, boolean higherDuration) {
        super(Stream.empty());
        this.potionItem = potionItem;
        this.effects = List.copyOf(effects);
        this.extraEffects = extraEffects;
        this.higherAmplifier = higherAmplifier;
        this.higherDuration = higherDuration;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        ItemStack potion = new ItemStack((ItemLike)(this.potionItem == null ? Items.f_42589_ : this.potionItem));
        PotionUtils.m_43552_((ItemStack)potion, this.effects);
        return new ItemStack[]{potion};
    }

    public boolean test(@Nullable ItemStack stack) {
        if (!(stack == null || stack.m_41619_() || this.potionItem != null && stack.m_41720_() != this.potionItem)) {
            ArrayList<MobEffectInstance> effectsLeft = new ArrayList<MobEffectInstance>(PotionUtils.m_43547_((ItemStack)stack));
            for (MobEffectInstance effect : this.effects) {
                if (effectsLeft.removeIf(left -> left.m_19544_() == effect.m_19544_() && (left.m_19564_() == effect.m_19564_() || this.higherAmplifier && left.m_19564_() > effect.m_19564_()) && (left.m_19544_().m_8093_() || left.m_19557_() == effect.m_19557_() || this.higherDuration && left.m_19557_() > effect.m_19557_()))) continue;
                return false;
            }
            return effectsLeft.isEmpty() || this.extraEffects;
        }
        return false;
    }

    @Nonnull
    public IntList m_43931_() {
        ItemStack[] stacks = this.m_43908_();
        IntArrayList ial = new IntArrayList(stacks.length);
        for (ItemStack stack : stacks) {
            ial.add(StackedContents.m_36496_((ItemStack)stack));
        }
        return ial;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public boolean m_43947_() {
        return this.potionItem == Items.f_41852_ || this.potionItem == null && this.effects.isEmpty();
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        if (this.potionItem == null) {
            json.add("item", (JsonElement)JsonNull.INSTANCE);
        } else {
            json.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.potionItem)).toString());
        }
        JsonArray jsonEffects = new JsonArray();
        for (MobEffectInstance effect : this.effects) {
            JsonObject effectJson = new JsonObject();
            effectJson.addProperty("potion", Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect.m_19544_())).toString());
            effectJson.addProperty("amplifier", (Number)effect.m_19564_());
            effectJson.addProperty("duration", (Number)effect.m_19557_());
            jsonEffects.add((JsonElement)effectJson);
        }
        json.add("effects", (JsonElement)jsonEffects);
        json.addProperty("extraEffects", Boolean.valueOf(this.extraEffects));
        json.addProperty("higherAmplifier", Boolean.valueOf(this.higherAmplifier));
        json.addProperty("higherDuration", Boolean.valueOf(this.higherDuration));
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<EffectIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Nonnull
        public EffectIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            Item potionItem;
            if (buffer.readBoolean()) {
                potionItem = (Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_());
                if (potionItem == null) {
                    potionItem = Items.f_41852_;
                }
            } else {
                potionItem = null;
            }
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
            int effectsSize = buffer.readInt();
            for (int i = 0; i < effectsSize; ++i) {
                MobEffect potion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(buffer.m_130281_());
                if (potion == null) {
                    potion = MobEffects.f_19596_;
                }
                int amplifier = buffer.readInt();
                int duration = buffer.readInt();
                effects.add(new MobEffectInstance(potion, duration, amplifier));
            }
            boolean extraEffects = buffer.readBoolean();
            boolean higherAmplifier = buffer.readBoolean();
            boolean higherDuration = buffer.readBoolean();
            return new EffectIngredient(potionItem, effects, extraEffects, higherAmplifier, higherDuration);
        }

        @Nonnull
        public EffectIngredient parse(JsonObject json) {
            Item potionItem;
            JsonElement itemJson = json.get("item");
            if (itemJson.isJsonNull()) {
                potionItem = null;
            } else {
                ResourceLocation potionRl = ResourceLocation.m_135820_((String)itemJson.getAsString());
                Item item = potionItem = potionRl == null ? null : (Item)ForgeRegistries.ITEMS.getValue(potionRl);
                if (potionItem == null) {
                    potionItem = Items.f_41852_;
                }
            }
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
            for (JsonElement effectJson : json.get("effects").getAsJsonArray()) {
                JsonObject effect = effectJson.getAsJsonObject();
                MobEffect potion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effect.get("potion").getAsString()));
                if (potion == null) {
                    potion = MobEffects.f_19596_;
                }
                int amplifier = effect.get("amplifier").getAsInt();
                int duration = effect.get("duration").getAsInt();
                effects.add(new MobEffectInstance(potion, duration, amplifier));
            }
            boolean extraEffects = false;
            if (json.has("extraEffects")) {
                extraEffects = json.get("extraEffects").getAsBoolean();
            }
            boolean higherAmplifier = true;
            if (json.has("higherAmplifier")) {
                higherAmplifier = json.get("higherAmplifier").getAsBoolean();
            }
            boolean higherDuration = true;
            if (json.has("higherDuration")) {
                higherDuration = json.get("higherDuration").getAsBoolean();
            }
            return new EffectIngredient(potionItem, effects, extraEffects, higherAmplifier, higherDuration);
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull EffectIngredient ingredient) {
            buffer.writeBoolean(ingredient.potionItem != null);
            if (ingredient.potionItem != null) {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ingredient.potionItem)));
            }
            buffer.writeInt(ingredient.effects.size());
            for (MobEffectInstance effect : ingredient.effects) {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect.m_19544_())));
                buffer.writeInt(effect.m_19564_());
                buffer.writeInt(effect.m_19557_());
            }
            buffer.writeBoolean(ingredient.extraEffects);
            buffer.writeBoolean(ingredient.higherAmplifier);
            buffer.writeBoolean(ingredient.higherDuration);
        }
    }
}

