/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.base.Suppliers;
import com.mojang.text2speech.Narrator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.RayTracing;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.util.ClientPlatformProxy;

public class WailaTickHandler {
    private static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static final Supplier<Narrator> NARRATOR = Suppliers.memoize(Narrator::getNarrator);
    private static String lastNarration = "";
    private static long lastNarrationTime = 0L;
    public TooltipRenderer tooltipRenderer = null;
    public ProgressTracker progressTracker = new ProgressTracker();

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    public static void narrate(ITooltip tooltip, boolean dedupe) {
        if (!NARRATOR.get().active() || tooltip.isEmpty()) {
            return;
        }
        String narration = tooltip.getMessage();
        if (dedupe) {
            if (narration.equals(lastNarration)) {
                return;
            }
            if (System.currentTimeMillis() - lastNarrationTime < 500L) {
                return;
            }
        }
        CompletableFuture.runAsync(() -> {
            Narrator narrator = NARRATOR.get();
            narrator.clear();
            narrator.say(StringUtil.m_14406_((String)narration), false);
        });
        lastNarration = narration;
        lastNarrationTime = System.currentTimeMillis();
    }

    public void tickClient() {
        BlockHitResult blockTarget;
        this.progressTracker.tick();
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        if (!config.shouldDisplayTooltip()) {
            this.tooltipRenderer = null;
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (!ClientPlatformProxy.shouldShowWithOverlay(client, client.f_91080_)) {
            return;
        }
        if (client.f_91068_ == null) {
            return;
        }
        ClientLevel world = client.f_91073_;
        LocalPlayer player = client.f_91074_;
        if (world == null || player == null) {
            this.tooltipRenderer = null;
            return;
        }
        RayTracing.INSTANCE.fire();
        HitResult target = RayTracing.INSTANCE.getTarget();
        Tooltip tooltip = new Tooltip();
        if (target == null) {
            this.tooltipRenderer = null;
            return;
        }
        Accessor<EntityHitResult> accessor = null;
        if (target instanceof BlockHitResult && (blockTarget = (BlockHitResult)target).m_6662_() != HitResult.Type.MISS) {
            BlockState blockState = world.m_8055_(blockTarget.m_82425_());
            BlockEntity tileEntity = world.m_7702_(blockTarget.m_82425_());
            accessor = WailaClientRegistration.INSTANCE.blockAccessor().blockState(blockState).blockEntity(tileEntity).hit(blockTarget).build();
        } else if (target instanceof EntityHitResult) {
            EntityHitResult entityTarget = (EntityHitResult)target;
            accessor = WailaClientRegistration.INSTANCE.entityAccessor().hit(entityTarget).entity(entityTarget.m_82443_()).build();
        }
        EntityAccessor originalAccessor = accessor;
        for (JadeRayTraceCallback jadeRayTraceCallback : WailaClientRegistration.INSTANCE.rayTraceCallback.callbacks()) {
            accessor = jadeRayTraceCallback.onRayTrace(target, accessor, originalAccessor);
        }
        ObjectDataCenter.set(accessor);
        if (accessor == null || accessor.getHitResult() == null) {
            this.tooltipRenderer = null;
            return;
        }
        if (!accessor.shouldDisplay()) {
            this.tooltipRenderer = null;
            return;
        }
        if (accessor.isServerConnected()) {
            boolean request = accessor.shouldRequestData();
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (request) {
                    accessor._requestData();
                }
            }
            if (request && ObjectDataCenter.getServerData() == null) {
                return;
            }
        }
        if (config.getDisplayMode() == IWailaConfig.DisplayMode.LITE && !ClientPlatformProxy.isShowDetailsPressed()) {
            Tooltip dummyTooltip = new Tooltip();
            accessor._gatherComponents($ -> {
                if (Math.abs(WailaCommonRegistration.INSTANCE.priorities.byValue((IJadeProvider)$)) > 5000) {
                    return tooltip;
                }
                return dummyTooltip;
            });
            if (!dummyTooltip.isEmpty()) {
                tooltip.sneakyDetails = true;
            }
        } else {
            accessor._gatherComponents($ -> tooltip);
        }
        for (JadeTooltipCollectedCallback jadeTooltipCollectedCallback : WailaClientRegistration.INSTANCE.tooltipCollectedCallback.callbacks()) {
            jadeTooltipCollectedCallback.onTooltipCollected(tooltip, accessor);
        }
        this.tooltipRenderer = new TooltipRenderer(tooltip, true);
    }
}

