/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders;

import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.itemborders.ItemBordersConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ItemBorders {
    public static void renderBorder(PoseStack poseStack, Slot slot) {
        ItemBorders.render(poseStack, slot.m_7993_(), slot.f_40220_, slot.f_40221_);
    }

    public static void renderBorder(PoseStack poseStack, ItemStack item, int x, int y) {
        if (((Boolean)ItemBordersConfig.getInstance().hotBar.get()).booleanValue()) {
            ItemBorders.render(new PoseStack(), item, x, y);
        }
    }

    private static void render(PoseStack poseStack, ItemStack item, int x, int y) {
        if (item.m_41619_()) {
            return;
        }
        Pair borderColors = ItemBordersConfig.getInstance().getBorderColorForItem(item);
        if (borderColors == null) {
            borderColors = new Pair(() -> TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE).m_131265_(), () -> TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE).m_131265_());
        }
        if (((Integer)((Supplier)borderColors.getFirst()).get() & 0xFFFFFF) == ChatFormatting.WHITE.m_126665_() && ((Integer)((Supplier)borderColors.getSecond()).get() & 0xFFFFFF) == ChatFormatting.WHITE.m_126665_() && !((Boolean)ItemBordersConfig.getInstance().showForCommon.get()).booleanValue()) {
            return;
        }
        RenderSystem.m_69465_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (Boolean)ItemBordersConfig.getInstance().overItems.get() != false ? 290.0 : 100.0);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        int startColor = (Integer)((Supplier)borderColors.getFirst()).get() & 0xFFFFFF;
        int endColor = (Integer)((Supplier)borderColors.getSecond()).get() & 0xFFFFFF;
        int topColor = (Boolean)ItemBordersConfig.getInstance().fullBorder.get() != false ? startColor | 0xEE000000 : startColor;
        int bottomColor = endColor | 0xEE000000;
        int xOffset = (Boolean)ItemBordersConfig.getInstance().squareCorners.get() != false ? 0 : 1;
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + 15), (int)topColor, (int)bottomColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 15), (int)(y + 1), (int)(x + 16), (int)(y + 15), (int)topColor, (int)bottomColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + xOffset), (int)y, (int)(x + 16 - xOffset), (int)(y + 1), (int)topColor, (int)topColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + xOffset), (int)(y + 15), (int)(x + 16 - xOffset), (int)(y + 16), (int)bottomColor, (int)bottomColor);
        if (((Boolean)ItemBordersConfig.getInstance().extraGlow.get()).booleanValue()) {
            int topAlpha = (topColor >> 24 & 0xFF) / 3;
            int bottomAlpha = (bottomColor >> 24 & 0xFF) / 3;
            int topGlowColor = topAlpha << 24 | topColor & 0xFFFFFF;
            int bottomGlowColor = bottomAlpha << 24 | bottomColor & 0xFFFFFF;
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 1), (int)(y + 1), (int)(x + 2), (int)(y + 15), (int)topGlowColor, (int)bottomGlowColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 14), (int)(y + 1), (int)(x + 15), (int)(y + 15), (int)topGlowColor, (int)bottomGlowColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 1), (int)(y + 1), (int)(x + 15), (int)(y + 2), (int)topGlowColor, (int)topGlowColor);
            GuiHelper.drawGradientRect((Matrix4f)matrix, (int)-1, (int)(x + 1), (int)(y + 14), (int)(x + 15), (int)(y + 15), (int)bottomGlowColor, (int)bottomGlowColor);
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
    }
}

