/*
 * Decompiled with CFR 0.152.
 */
package snownee.drawer.client;

import com.google.common.collect.Lists;
import com.jaquadro.minecraft.storagedrawers.client.renderer.StorageRenderItem;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import snownee.drawer.ModTags;
import snownee.drawer.client.ClientDrawerTooltip;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class TooltipEvents {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###");
    private static boolean tagsUpdated;
    public static StorageRenderItem storageItemRender;

    @SubscribeEvent
    public static void init(RegisterClientReloadListenersEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        storageItemRender = new StorageRenderItem(minecraft.m_91097_(), minecraft.m_91304_(), minecraft.getItemColors());
        event.registerReloadListener((PreparableReloadListener)storageItemRender);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, TooltipEvents::onTooltip);
        MinecraftForge.EVENT_BUS.addListener(TooltipEvents::onTagsUpdated);
    }

    @SubscribeEvent
    public static void registerClientTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ClientDrawerTooltip.class, Function.identity());
    }

    private static void onTagsUpdated(TagsUpdatedEvent event) {
        tagsUpdated = true;
    }

    private static void onTooltip(RenderTooltipEvent.GatherComponents event) {
        if (!tagsUpdated) {
            return;
        }
        List<Object2IntMap.Entry<ItemStack>> contents = TooltipEvents.getContents(event.getItemStack());
        if (contents.isEmpty()) {
            return;
        }
        ArrayList lines = Lists.newArrayList();
        if (Screen.m_96638_()) {
            for (Object2IntMap.Entry<ItemStack> content : contents) {
                lines.add(Either.left((Object)FormattedText.m_130775_((String)(((ItemStack)content.getKey()).m_41786_().getString() + " x" + DECIMAL_FORMAT.format(content.getIntValue())))));
            }
        } else {
            lines.add(Either.right((Object)new ClientDrawerTooltip(contents)));
        }
        event.getTooltipElements().addAll(Math.min(3, event.getTooltipElements().size()), lines);
    }

    public static List<Object2IntMap.Entry<ItemStack>> getContents(ItemStack drawer) {
        ArrayList list;
        block4: {
            CompoundTag tile;
            block3: {
                tile = drawer.m_41737_("tile");
                if (tile == null || !tile.m_128441_("Drawers")) {
                    return Collections.EMPTY_LIST;
                }
                list = Lists.newArrayList();
                if (!drawer.m_204117_(ModTags.COMPACTING_DRAWERS)) break block3;
                CompoundTag drawersTag = tile.m_128469_("Drawers");
                int count = drawersTag.m_128451_("Count");
                for (Tag nbt : drawersTag.m_128437_("Items", 10)) {
                    int conv;
                    CompoundTag tag = (CompoundTag)nbt;
                    ItemStack content = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
                    if (content.m_41619_() || (conv = tag.m_128451_("Conv")) <= 0) continue;
                    int amount = count / conv;
                    list.add(new AbstractObject2IntMap.BasicEntry((Object)content, amount));
                }
                break block4;
            }
            if (!drawer.m_204117_(ModTags.DRAWERS)) break block4;
            for (Tag nbt : tile.m_128437_("Drawers", 10)) {
                CompoundTag tag = (CompoundTag)nbt;
                ItemStack content = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
                if (content.m_41619_()) continue;
                int amount = tag.m_128451_("Count");
                list.add(new AbstractObject2IntMap.BasicEntry((Object)content, amount));
            }
        }
        return list;
    }
}

