/*
 * Decompiled with CFR 0.152.
 */
package snownee.drawer.client;

import com.jaquadro.minecraft.storagedrawers.client.renderer.StorageRenderItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.drawer.client.TooltipEvents;

@OnlyIn(value=Dist.CLIENT)
public class ClientDrawerTooltip
implements TooltipComponent,
ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/gui/container/bundle.png");
    private final List<Object2IntMap.Entry<ItemStack>> contents;

    public ClientDrawerTooltip(List<Object2IntMap.Entry<ItemStack>> contents) {
        this.contents = contents;
    }

    public int m_142103_() {
        return 26;
    }

    public int m_142069_(Font p_169952_) {
        return this.contents.size() * 18 + 2;
    }

    public void m_183452_(Font font, int x, int y, PoseStack poseStack, ItemRenderer itemRenderer, int p_194047_) {
        int i = this.contents.size();
        int j = 1;
        boolean flag = false;
        int k = 0;
        for (int l = 0; l < j; ++l) {
            for (int i1 = 0; i1 < i; ++i1) {
                int j1 = x + i1 * 18 + 1;
                int k1 = y + l * 20 + 1;
                this.renderSlot(j1, k1, k++, flag, font, poseStack, TooltipEvents.storageItemRender, p_194047_);
            }
        }
        this.drawBorder(x, y, i, j, poseStack, p_194047_);
    }

    private void renderSlot(int x, int y, int slot, boolean p_194030_, Font font, PoseStack poseStack, StorageRenderItem itemRenderer, int p_194034_) {
        if (slot >= this.contents.size()) {
            this.blit(poseStack, x, y, p_194034_, p_194030_ ? Texture.BLOCKED_SLOT : Texture.SLOT);
        } else {
            Object2IntMap.Entry<ItemStack> entry = this.contents.get(slot);
            ItemStack itemstack = (ItemStack)entry.getKey();
            itemstack.m_41764_(entry.getIntValue());
            this.blit(poseStack, x, y, p_194034_, Texture.SLOT);
            itemRenderer.overrideStack = itemstack;
            itemRenderer.m_174229_(null, itemstack, x + 1, y + 1, slot);
            itemRenderer.f_115093_ += 500.0f;
            itemRenderer.m_115174_(font, itemstack, x + 1, y + 1, null);
            itemRenderer.f_115093_ -= 500.0f;
        }
    }

    private void drawBorder(int p_194020_, int p_194021_, int p_194022_, int p_194023_, PoseStack p_194024_, int p_194025_) {
        this.blit(p_194024_, p_194020_, p_194021_, p_194025_, Texture.BORDER_CORNER_TOP);
        this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1, p_194021_, p_194025_, Texture.BORDER_CORNER_TOP);
        for (int i = 0; i < p_194022_; ++i) {
            this.blit(p_194024_, p_194020_ + 1 + i * 18, p_194021_, p_194025_, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(p_194024_, p_194020_ + 1 + i * 18, p_194021_ + p_194023_ * 20, p_194025_, Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (int j = 0; j < p_194023_; ++j) {
            this.blit(p_194024_, p_194020_, p_194021_ + j * 20 + 1, p_194025_, Texture.BORDER_VERTICAL);
            this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1, p_194021_ + j * 20 + 1, p_194025_, Texture.BORDER_VERTICAL);
        }
        this.blit(p_194024_, p_194020_, p_194021_ + p_194023_ * 20, p_194025_, Texture.BORDER_CORNER_BOTTOM);
        this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1, p_194021_ + p_194023_ * 20, p_194025_, Texture.BORDER_CORNER_BOTTOM);
    }

    private void blit(PoseStack p_194036_, int p_194037_, int p_194038_, int p_194039_, Texture p_194040_) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        GuiComponent.m_93143_((PoseStack)p_194036_, (int)p_194037_, (int)p_194038_, (int)p_194039_, (float)p_194040_.x, (float)p_194040_.y, (int)p_194040_.w, (int)p_194040_.h, (int)128, (int)128);
    }

    static enum Texture {
        SLOT(0, 0, 18, 20),
        BLOCKED_SLOT(0, 40, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int p_169928_, int p_169929_, int p_169930_, int p_169931_) {
            this.x = p_169928_;
            this.y = p_169929_;
            this.w = p_169930_;
            this.h = p_169931_;
        }
    }
}

