/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalents2;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.util.NBTUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DogLocationStorage
extends SavedData {
    private Map<UUID, DogLocationData> locationDataMap = Maps.newConcurrentMap();

    public static DogLocationStorage get(Level world) {
        if (!(world instanceof ServerLevel)) {
            throw new RuntimeException("Tried to access dog location data from the client. This should not happen...");
        }
        ServerLevel overworld = world.m_7654_().m_129880_(Level.f_46428_);
        DimensionDataStorage storage = overworld.m_8895_();
        return (DogLocationStorage)storage.m_164861_(DogLocationStorage::load, DogLocationStorage::new, "dog_locations");
    }

    public Stream<DogLocationData> getDogs(LivingEntity owner) {
        UUID ownerId = owner.m_20148_();
        return this.locationDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId()));
    }

    public Stream<DogLocationData> getDogs(LivingEntity owner, ResourceKey<Level> key) {
        UUID ownerId = owner.m_20148_();
        return this.locationDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId())).filter(data -> key.equals(data.getDimension()));
    }

    @Nullable
    public DogLocationData getData(DogEntity dogIn) {
        return this.getData(dogIn.m_20148_());
    }

    @Nullable
    public DogLocationData getData(UUID uuid) {
        if (this.locationDataMap.containsKey(uuid)) {
            return this.locationDataMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public DogLocationData remove(DogEntity dogIn) {
        return this.remove(dogIn.m_20148_());
    }

    @Nullable
    public DogLocationData getOrCreateData(DogEntity dogIn) {
        UUID uuid = dogIn.m_20148_();
        return this.locationDataMap.computeIfAbsent(uuid, $ -> {
            this.m_77762_();
            return DogLocationData.from(this, dogIn);
        });
    }

    @Nullable
    public DogLocationData remove(UUID uuid) {
        if (this.locationDataMap.containsKey(uuid)) {
            DogLocationData storage = this.locationDataMap.remove(uuid);
            this.m_77762_();
            return storage;
        }
        return null;
    }

    @Nullable
    public DogLocationData putData(DogEntity dogIn) {
        UUID uuid = dogIn.m_20148_();
        DogLocationData storage = new DogLocationData(this, uuid);
        this.locationDataMap.put(uuid, storage);
        this.m_77762_();
        return storage;
    }

    public Set<UUID> getAllUUID() {
        return Collections.unmodifiableSet(this.locationDataMap.keySet());
    }

    public Collection<DogLocationData> getAll() {
        return Collections.unmodifiableCollection(this.locationDataMap.values());
    }

    public static DogLocationStorage load(CompoundTag nbt) {
        DogLocationStorage store = new DogLocationStorage();
        store.locationDataMap.clear();
        ListTag list = nbt.m_128437_("locationData", 10);
        if (list.isEmpty()) {
            list = nbt.m_128437_("dog_locations", 10);
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag locationCompound = list.m_128728_(i);
            UUID uuid = NBTUtil.getUniqueId(locationCompound, "uuid");
            if (uuid == null) {
                uuid = NBTUtil.getUniqueId(locationCompound, "entityId");
            }
            DogLocationData locationData = new DogLocationData(store, uuid);
            locationData.read(locationCompound);
            if (uuid == null) {
                DoggyTalents2.LOGGER.info("Failed to load dog location data. Please report to mod author...");
                DoggyTalents2.LOGGER.info((Object)locationData);
                continue;
            }
            store.locationDataMap.put(uuid, locationData);
        }
        return store;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, DogLocationData> entry : this.locationDataMap.entrySet()) {
            CompoundTag locationCompound = new CompoundTag();
            DogLocationData locationData = entry.getValue();
            NBTUtil.putUniqueId(locationCompound, "uuid", entry.getKey());
            locationData.write(locationCompound);
            list.add((Object)locationCompound);
        }
        compound.m_128365_("locationData", (Tag)list);
        return compound;
    }
}

