/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.ClientSetup;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.model.DogModel;
import doggytalents.client.entity.render.CollarRenderManager;
import doggytalents.client.entity.render.RenderUtil;
import doggytalents.client.entity.render.layer.BoneLayer;
import doggytalents.client.entity.render.layer.LayerFactory;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.DogEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class DogRenderer
extends MobRenderer<DogEntity, DogModel<DogEntity>> {
    public DogRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new DogModel(ctx.m_174023_(ClientSetup.DOG)), 0.5f);
        this.m_115326_(new BoneLayer(this, ctx.m_234598_()));
        for (LayerFactory<DogEntity, DogModel<DogEntity>> layer : CollarRenderManager.getLayers()) {
            this.m_115326_(layer.createLayer((RenderLayerParent<DogEntity, DogModel<DogEntity>>)this, ctx));
        }
    }

    protected float getBob(DogEntity livingBase, float partialTicks) {
        return livingBase.getTailRotation();
    }

    public void render(DogEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        double d0;
        if (entityIn.isDogWet()) {
            float f = entityIn.getShadingWhileWet(partialTicks);
            ((DogModel)this.f_115290_).m_102419_(f, f, f);
        }
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (this.m_6512_((Mob)entityIn) && (d0 = this.f_114476_.m_114471_((Entity)entityIn)) <= 4096.0) {
            String tip = entityIn.getMode().getTip();
            String label = String.format((Boolean)ConfigHandler.SERVER.DOG_GENDER.get() != false ? "%s(%d)%s" : "%s(%d)", Component.m_237115_((String)tip).getString(), Mth.m_14167_((float)entityIn.getDogHunger()), Component.m_237115_((String)entityIn.getGender().getUnlocalisedTip()).getString());
            RenderUtil.renderLabelWithScale(entityIn, this, this.f_114476_, label, matrixStackIn, bufferIn, packedLightIn, 0.01f, 0.12f);
            if (d0 <= 25.0 && this.f_114476_.f_114358_.m_90592_().m_6144_()) {
                RenderUtil.renderLabelWithScale(entityIn, this, this.f_114476_, entityIn.getOwnersName().orElseGet(() -> this.getNameUnknown(entityIn)), matrixStackIn, bufferIn, packedLightIn, 0.01f, -0.25f);
            }
        }
        if (entityIn.isDogWet()) {
            ((DogModel)this.f_115290_).m_102419_(1.0f, 1.0f, 1.0f);
        }
    }

    private Component getNameUnknown(DogEntity dogIn) {
        return Component.m_237115_((String)(dogIn.m_21805_() != null ? "entity.doggytalents.dog.unknown_owner" : "entity.doggytalents.dog.untamed"));
    }

    public ResourceLocation getTextureLocation(DogEntity dogIn) {
        return DogTextureManager.INSTANCE.getTexture(dogIn);
    }

    protected void scale(DogEntity dogIn, PoseStack matrixStackIn, float partialTickTime) {
        float size = (float)dogIn.getDogSize() * 0.3f + 0.1f;
        matrixStackIn.m_85841_(size, size, size);
        this.f_114477_ = size * 0.5f;
    }
}

