/*
 * Decompiled with CFR 0.152.
 */
package dicemc.money.event;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dicemc.money.MoneyMod;
import dicemc.money.setup.Config;
import dicemc.money.storage.DatabaseManager;
import dicemc.money.storage.MoneyWSD;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dicemcmm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    public static Map<UUID, Long> timeSinceClick = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().f_46443_ && event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            double balP = MoneyWSD.get(player.m_20194_().m_129783_()).getBalance(MoneyMod.AcctTypes.PLAYER.key, player.m_20148_());
            player.m_213846_((Component)Component.m_237113_((String)Config.getFormattedCurrency(balP)));
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        Player player;
        double balp;
        double loss;
        if (!event.getEntity().m_9236_().f_46443_ && event.getEntity() instanceof Player && (loss = (balp = MoneyWSD.get((player = (Player)event.getEntity()).m_20194_().m_129783_()).getBalance(MoneyMod.AcctTypes.PLAYER.key, player.m_20148_())) * (Double)Config.LOSS_ON_DEATH.get()) > 0.0) {
            MoneyWSD.get(player.m_20194_().m_129783_()).changeBalance(MoneyMod.AcctTypes.PLAYER.key, player.m_20148_(), -loss);
            if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                MoneyMod.dbm.postEntry(System.currentTimeMillis(), DatabaseManager.NIL, MoneyMod.AcctTypes.SERVER.key, "Server", player.m_20148_(), MoneyMod.AcctTypes.PLAYER.key, player.m_7755_().getString(), -loss, "Loss on Death Event");
            }
            player.m_213846_((Component)Component.m_237110_((String)"message.death", (Object[])new Object[]{Config.getFormattedCurrency(loss)}));
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        boolean cancel = false;
        if (event.getLevel().m_7702_(event.getPos().m_122012_()) != null && event.getLevel().m_7702_(event.getPos().m_122012_()).getPersistentData().m_128441_("is-shop")) {
            cancel = true;
        }
        if (event.getLevel().m_7702_(event.getPos().m_122019_()) != null && event.getLevel().m_7702_(event.getPos().m_122019_()).getPersistentData().m_128441_("is-shop")) {
            cancel = true;
        }
        if (event.getLevel().m_7702_(event.getPos().m_122029_()) != null && event.getLevel().m_7702_(event.getPos().m_122029_()).getPersistentData().m_128441_("is-shop")) {
            cancel = true;
        }
        if (event.getLevel().m_7702_(event.getPos().m_122024_()) != null && event.getLevel().m_7702_(event.getPos().m_122024_()).getPersistentData().m_128441_("is-shop")) {
            cancel = true;
        }
        if (event.getLevel().m_7702_(event.getPos().m_7494_()) != null && event.getLevel().m_7702_(event.getPos().m_7494_()).getPersistentData().m_128441_("is-shop")) {
            cancel = true;
        }
        if (event.getLevel().m_7702_(event.getPos().m_7495_()) != null && event.getLevel().m_7702_(event.getPos().m_7495_()).getPersistentData().m_128441_("is-shop")) {
            cancel = true;
        }
        event.setCanceled(cancel);
    }

    @SubscribeEvent
    public static void onShopBreak(BlockEvent.BreakEvent event) {
        if (!event.getLevel().m_5776_() && event.getLevel().m_8055_(event.getPos()).m_60734_() instanceof WallSignBlock) {
            SignBlockEntity tile = (SignBlockEntity)event.getLevel().m_7702_(event.getPos());
            CompoundTag nbt = tile.getPersistentData();
            if (!nbt.m_128456_() && nbt.m_128441_("shop-activated")) {
                Player player = event.getPlayer();
                boolean hasPerms = player.m_20310_(((Integer)Config.ADMIN_LEVEL.get()).intValue());
                if (!nbt.m_128342_("owner").equals(player.m_20148_())) {
                    event.setCanceled(!hasPerms);
                } else if (nbt.m_128342_("owner").equals(player.m_20148_()) || hasPerms) {
                    WallSignBlock cfr_ignored_0 = (WallSignBlock)tile.m_58900_().m_60734_();
                    BlockPos backBlock = BlockPos.m_122022_((long)BlockPos.m_121915_((long)event.getPos().m_121878_(), (Direction)((Direction)tile.m_58900_().m_61143_((Property)WallSignBlock.f_58064_)).m_122424_()));
                    event.getLevel().m_7702_(backBlock).getPersistentData().m_128473_("is-shop");
                }
            }
        } else if (!event.getLevel().m_5776_() && event.getLevel().m_7702_(event.getPos()) != null && event.getLevel().m_7702_(event.getPos()).getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && event.getLevel().m_7702_(event.getPos()).getPersistentData().m_128441_("is-shop")) {
            Player player = event.getPlayer();
            event.setCanceled(!player.m_20310_(((Integer)Config.ADMIN_LEVEL.get()).intValue()));
        }
    }

    @SubscribeEvent
    public static void onStorageOpen(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity invTile = event.getLevel().m_7702_(event.getPos());
        if (invTile != null && invTile.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() && invTile.getPersistentData().m_128441_("is-shop") && !invTile.getPersistentData().m_128342_("owner").equals(event.getEntity().m_20148_())) {
            event.setCanceled(!event.getEntity().m_20310_(((Integer)Config.ADMIN_LEVEL.get()).intValue()));
        }
    }

    @SubscribeEvent
    public static void onSignLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        SignBlockEntity tile;
        CompoundTag nbt;
        if (!event.getLevel().f_46443_ && event.getLevel().m_8055_(event.getPos()).m_60734_() instanceof WallSignBlock && (nbt = (tile = (SignBlockEntity)event.getLevel().m_7702_(event.getPos())).getPersistentData()).m_128441_("shop-activated")) {
            EventHandler.getSaleInfo(nbt, event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onSignRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getLevel().f_46443_ && event.getLevel().m_8055_(event.getPos()).m_60734_() instanceof WallSignBlock) {
            BlockEntity invTile;
            BlockState state = event.getLevel().m_8055_(event.getPos());
            WallSignBlock sign = (WallSignBlock)state.m_60734_();
            BlockPos backBlock = BlockPos.m_122022_((long)BlockPos.m_121915_((long)event.getPos().m_121878_(), (Direction)((Direction)state.m_61143_((Property)WallSignBlock.f_58064_)).m_122424_()));
            if (event.getLevel().m_7702_(backBlock) != null && (invTile = event.getLevel().m_7702_(backBlock)).getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                SignBlockEntity tile = (SignBlockEntity)event.getLevel().m_7702_(event.getPos());
                CompoundTag nbt = tile.m_187480_();
                if (!nbt.m_128441_("ForgeData") || !nbt.m_128469_("ForgeData").m_128441_("shop-activated")) {
                    if (EventHandler.activateShop(invTile, tile, event.getLevel(), event.getPos(), nbt, event.getEntity())) {
                        event.setUseBlock(Event.Result.DENY);
                    }
                } else {
                    EventHandler.processTransaction(invTile, tile, event.getEntity());
                    event.setUseBlock(Event.Result.DENY);
                }
            }
        }
    }

    private static boolean activateShop(BlockEntity storage, SignBlockEntity tile, Level world, BlockPos pos, CompoundTag nbt, Player player) {
        MutableComponent actionEntry = Component.Serializer.m_130701_((String)nbt.m_128461_("Text1"));
        MutableComponent priceEntry = Component.Serializer.m_130701_((String)nbt.m_128461_("Text4"));
        LazyOptional inv = storage.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP);
        ItemStack srcStack = inv.map(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                if (c.getStackInSlot(i).m_41619_()) continue;
                return c.getStackInSlot(i);
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
        if (srcStack.equals(ItemStack.f_41583_, true)) {
            return false;
        }
        if (actionEntry.getString().equalsIgnoreCase("[buy]") || actionEntry.getString().equalsIgnoreCase("[sell]") || actionEntry.getString().equalsIgnoreCase("[server-buy]") || actionEntry.getString().equalsIgnoreCase("[server-sell]")) {
            if (actionEntry.getString().equalsIgnoreCase("[server-buy]") || actionEntry.getString().equalsIgnoreCase("[server-sell]")) {
                if (!player.m_20310_(((Integer)Config.ADMIN_LEVEL.get()).intValue())) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.activate.failure.admin"));
                    return false;
                }
            } else if (!player.m_20310_(((Integer)Config.SHOP_LEVEL.get()).intValue())) {
                player.m_213846_((Component)Component.m_237115_((String)"message.activate.failure.admin"));
                return false;
            }
            try {
                double price = Math.abs(Double.valueOf(priceEntry.getString()));
                tile.getPersistentData().m_128347_("price", price);
                tile.m_59732_(0, (Component)Component.m_237113_((String)actionEntry.getString()).m_130940_(ChatFormatting.BLUE));
                tile.m_59732_(3, (Component)Component.m_237113_((String)Config.getFormattedCurrency(price)).m_130940_(ChatFormatting.GOLD));
                switch (actionEntry.getString().toLowerCase()) {
                    case "[buy]": {
                        tile.getPersistentData().m_128359_("shop-type", "buy");
                        break;
                    }
                    case "[sell]": {
                        tile.getPersistentData().m_128359_("shop-type", "sell");
                        break;
                    }
                    case "[server-buy]": {
                        tile.getPersistentData().m_128359_("shop-type", "server-buy");
                        break;
                    }
                    case "[server-sell]": {
                        tile.getPersistentData().m_128359_("shop-type", "server-sell");
                        break;
                    }
                }
                tile.getPersistentData().m_128379_("shop-activated", true);
                tile.getPersistentData().m_128362_("owner", player.m_20148_());
                ListTag lnbt = new ListTag();
                inv.ifPresent(p -> {
                    for (int i = 0; i < p.getSlots(); ++i) {
                        ItemStack inSlot = p.getStackInSlot(i);
                        if (inSlot.m_41619_()) continue;
                        if (inSlot.m_41720_() instanceof WritableBookItem) {
                            lnbt.add((Object)EventHandler.getItemFromBook(inSlot));
                            continue;
                        }
                        lnbt.add((Object)inSlot.serializeNBT());
                    }
                });
                tile.getPersistentData().m_128365_("items", (Tag)lnbt);
                tile.m_187480_();
                tile.m_6596_();
                storage.getPersistentData().m_128379_("is-shop", true);
                storage.getPersistentData().m_128362_("owner", player.m_20148_());
                storage.m_187480_();
                BlockState state = world.m_8055_(pos);
                world.m_7260_(pos, state, state, 2);
                return true;
            }
            catch (NumberFormatException e) {
                player.m_213846_((Component)Component.m_237115_((String)"message.activate.failure.money"));
                world.m_46953_(pos, true, (Entity)player);
            }
        }
        return false;
    }

    private static CompoundTag getItemFromBook(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || nbt.m_128456_()) {
            return stack.serializeNBT();
        }
        String page = nbt.m_128437_("pages", 8).get(0).m_7916_();
        if (page.substring(0, 7).equalsIgnoreCase("vending")) {
            String subStr = page.substring(8);
            try {
                stack = ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)subStr));
                return stack.serializeNBT();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return stack.serializeNBT();
    }

    private static void getSaleInfo(CompoundTag nbt, Player player) {
        if (System.currentTimeMillis() - timeSinceClick.getOrDefault(player.m_20148_(), 0L) < 1500L) {
            return;
        }
        String type = nbt.m_128461_("shop-type");
        boolean isBuy = type.equalsIgnoreCase("buy") || type.equalsIgnoreCase("server-buy");
        ArrayList<ItemStack> transItems = new ArrayList<ItemStack>();
        ListTag itemsList = nbt.m_128437_("items", 10);
        for (int i = 0; i < itemsList.size(); ++i) {
            transItems.add(ItemStack.m_41712_((CompoundTag)itemsList.m_128728_(i)));
        }
        double value = nbt.m_128459_("price");
        MutableComponent itemComponent = EventHandler.getTransItemsDisplayString(transItems);
        if (isBuy) {
            player.m_213846_((Component)Component.m_237110_((String)"message.shop.info", (Object[])new Object[]{itemComponent, Config.getFormattedCurrency(value)}));
        } else {
            player.m_213846_((Component)Component.m_237110_((String)"message.shop.info", (Object[])new Object[]{Config.getFormattedCurrency(value), itemComponent}));
        }
        timeSinceClick.put(player.m_20148_(), System.currentTimeMillis());
    }

    private static MutableComponent getTransItemsDisplayString(List<ItemStack> list) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int l = 0; l < list.size(); ++l) {
            boolean hadMatch = false;
            for (int i = 0; i < items.size(); ++i) {
                if (!list.get(l).m_41656_((ItemStack)items.get(i)) || !ItemStack.m_41658_((ItemStack)list.get(l), (ItemStack)((ItemStack)items.get(i)))) continue;
                ((ItemStack)items.get(i)).m_41769_(list.get(l).m_41613_());
                hadMatch = true;
                break;
            }
            if (hadMatch) continue;
            items.add(list.get(l));
        }
        MutableComponent itemComponent = Component.m_237113_((String)"");
        boolean isFirst = true;
        for (ItemStack item : items) {
            if (!isFirst) {
                itemComponent.m_130946_(", ");
            }
            itemComponent.m_130946_(item.m_41613_() + "x ");
            itemComponent.m_7220_(item.m_41611_());
            isFirst = false;
        }
        return itemComponent;
    }

    private static void processTransaction(BlockEntity tile, SignBlockEntity sign, Player player) {
        MoneyWSD wsd = MoneyWSD.get(player.m_20194_().m_129783_());
        CompoundTag nbt = sign.getPersistentData();
        LazyOptional inv = tile.getCapability(ForgeCapabilities.ITEM_HANDLER);
        ArrayList<ItemStack> transItems = new ArrayList<ItemStack>();
        HashMap<ItemStack, ItemStack> consolidatedItems = new HashMap<ItemStack, ItemStack>();
        ListTag itemsList = nbt.m_128437_("items", 10);
        for (int i = 0; i < itemsList.size(); ++i) {
            ItemStack srcStack = ItemStack.m_41712_((CompoundTag)itemsList.m_128728_(i));
            ItemStack keyStack = srcStack.m_41777_();
            keyStack.m_41764_(1);
            boolean hasEntry = false;
            for (Map.Entry map : consolidatedItems.entrySet()) {
                if (!((ItemStack)map.getKey()).m_41656_(srcStack) || !ItemStack.m_41658_((ItemStack)((ItemStack)map.getKey()), (ItemStack)srcStack)) continue;
                ((ItemStack)map.getValue()).m_41769_(srcStack.m_41613_());
                hasEntry = true;
            }
            if (hasEntry) continue;
            consolidatedItems.put(keyStack, srcStack);
        }
        for (Map.Entry map : consolidatedItems.entrySet()) {
            transItems.add((ItemStack)map.getValue());
        }
        String action = nbt.m_128461_("shop-type");
        double value = nbt.m_128459_("price");
        if (action.equalsIgnoreCase("buy")) {
            double balP = wsd.getBalance(MoneyMod.AcctTypes.PLAYER.key, player.m_20148_());
            if (value > balP) {
                player.m_213846_((Component)Component.m_237115_((String)"message.shop.buy.failure.funds"));
                return;
            }
            HashMap slotMap = new HashMap();
            for (int tf = 0; tf < transItems.size(); ++tf) {
                int[] stackSize = new int[]{((ItemStack)transItems.get(tf)).m_41613_()};
                Integer t = tf;
                Optional test = inv.map(p -> {
                    for (int i = 0; i < p.getSlots(); ++i) {
                        ItemStack inSlot = ItemStack.f_41583_;
                        if (slotMap.containsKey(i) && ((ItemStack)transItems.get(t)).m_41720_().equals(((ItemStack)slotMap.get(i)).m_41720_()) && ItemStack.m_41658_((ItemStack)((ItemStack)transItems.get(t)), (ItemStack)((ItemStack)slotMap.get(i)))) {
                            inSlot = p.extractItem(i, stackSize[0] + ((ItemStack)slotMap.get(i)).m_41613_(), true);
                            inSlot.m_41774_(((ItemStack)slotMap.get(i)).m_41613_());
                        } else {
                            inSlot = p.extractItem(i, stackSize[0], true);
                        }
                        if (inSlot.m_41720_().equals(((ItemStack)transItems.get(t)).m_41720_()) && ItemStack.m_41658_((ItemStack)inSlot, (ItemStack)((ItemStack)transItems.get(t)))) {
                            slotMap.merge(i, inSlot, (s, o) -> {
                                s.m_41769_(o.m_41613_());
                                return s;
                            });
                            stackSize[0] = stackSize[0] - inSlot.m_41613_();
                        }
                        if (stackSize[0] <= 0) break;
                    }
                    return stackSize[0] <= 0;
                });
                if (((Boolean)test.get()).booleanValue()) continue;
                player.m_213846_((Component)Component.m_237115_((String)"message.shop.buy.failure.stock"));
                return;
            }
            UUID shopOwner = nbt.m_128342_("owner");
            wsd.transferFunds(MoneyMod.AcctTypes.PLAYER.key, player.m_20148_(), MoneyMod.AcctTypes.PLAYER.key, shopOwner, value);
            if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                String itemPrint = "";
                itemsList.forEach(a -> itemPrint.concat(a.m_7916_()));
                MoneyMod.dbm.postEntry(System.currentTimeMillis(), player.m_20148_(), MoneyMod.AcctTypes.PLAYER.key, player.m_7755_().getString(), shopOwner, MoneyMod.AcctTypes.PLAYER.key, ((GameProfile)player.m_20194_().m_129927_().m_11002_(shopOwner).get()).getName(), value, itemsList.m_7916_());
            }
            inv.ifPresent(p -> {
                for (Map.Entry map : slotMap.entrySet()) {
                    ItemStack pStack = p.extractItem(((Integer)map.getKey()).intValue(), ((ItemStack)map.getValue()).m_41613_(), false);
                    if (player.m_36356_(pStack)) continue;
                    player.m_36176_(pStack, false);
                }
            });
            MutableComponent msg = Component.m_237110_((String)"message.shop.buy.success", (Object[])new Object[]{EventHandler.getTransItemsDisplayString(transItems), Config.getFormattedCurrency(value)});
            player.m_5661_((Component)msg, true);
            player.m_20194_().m_213846_((Component)msg);
            return;
        }
        if (action.equalsIgnoreCase("sell")) {
            UUID shopOwner = nbt.m_128342_("owner");
            double balP = wsd.getBalance(MoneyMod.AcctTypes.PLAYER.key, shopOwner);
            if (value > balP) {
                player.m_213846_((Component)Component.m_237115_((String)"message.shop.sell.failure.funds"));
                return;
            }
            HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>();
            for (int t = 0; t < transItems.size(); ++t) {
                int stackSize = ((ItemStack)transItems.get(t)).m_41613_();
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack inSlot = player.m_150109_().m_8020_(i).m_41777_();
                    int count = stackSize > inSlot.m_41613_() ? inSlot.m_41613_() : stackSize;
                    inSlot.m_41764_(count);
                    if (slotMap.containsKey(i) && ((ItemStack)transItems.get(t)).m_41720_().equals(((ItemStack)slotMap.get(i)).m_41720_()) && ItemStack.m_41658_((ItemStack)((ItemStack)transItems.get(t)), (ItemStack)((ItemStack)slotMap.get(i)))) {
                        count = stackSize + ((ItemStack)slotMap.get(i)).m_41613_() > inSlot.m_41613_() ? inSlot.m_41613_() : stackSize + ((ItemStack)slotMap.get(i)).m_41613_();
                        inSlot.m_41764_(count);
                    }
                    if (inSlot.m_41720_().equals(((ItemStack)transItems.get(t)).m_41720_()) && ItemStack.m_41658_((ItemStack)inSlot, (ItemStack)((ItemStack)transItems.get(t)))) {
                        slotMap.merge(i, inSlot, (s, o) -> {
                            s.m_41769_(o.m_41613_());
                            return s;
                        });
                        stackSize -= inSlot.m_41613_();
                    }
                    if (stackSize <= 0) break;
                }
                if (stackSize <= 0) continue;
                player.m_213846_((Component)Component.m_237115_((String)"message.shop.sell.failure.stock"));
                return;
            }
            HashMap invSlotMap = new HashMap();
            for (int t = 0; t < transItems.size(); ++t) {
                ItemStack sim = ((ItemStack)transItems.get(t)).m_41777_();
                Optional test = inv.map(p -> {
                    for (int i = 0; i < p.getSlots(); ++i) {
                        ItemStack insertResult = p.insertItem(i, sim, true);
                        if (insertResult.m_41619_()) {
                            invSlotMap.merge(i, sim.m_41777_(), (s, o) -> {
                                s.m_41769_(o.m_41613_());
                                return s;
                            });
                            sim.m_41764_(0);
                            break;
                        }
                        if (insertResult.m_41613_() == sim.m_41613_()) continue;
                        ItemStack insertSuccess = sim.m_41777_();
                        insertSuccess.m_41774_(insertResult.m_41613_());
                        sim.m_41764_(insertResult.m_41613_());
                        invSlotMap.merge(i, insertSuccess, (s, o) -> {
                            s.m_41769_(insertSuccess.m_41613_());
                            return s;
                        });
                    }
                    if (!sim.m_41619_()) {
                        player.m_213846_((Component)Component.m_237115_((String)"message.shop.sell.failure.space"));
                        return false;
                    }
                    return true;
                });
                if (((Boolean)test.get()).booleanValue()) continue;
                return;
            }
            wsd.transferFunds(MoneyMod.AcctTypes.PLAYER.key, shopOwner, MoneyMod.AcctTypes.PLAYER.key, player.m_20148_(), value);
            if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                String itemPrint = "";
                itemsList.forEach(a -> itemPrint.concat(a.m_7916_()));
                MoneyMod.dbm.postEntry(System.currentTimeMillis(), shopOwner, MoneyMod.AcctTypes.PLAYER.key, ((GameProfile)player.m_20194_().m_129927_().m_11002_(shopOwner).get()).getName(), player.m_20148_(), MoneyMod.AcctTypes.PLAYER.key, player.m_7755_().getString(), value, itemsList.m_7916_());
            }
            for (Map.Entry pSlots : slotMap.entrySet()) {
                player.m_150109_().m_7407_(((Integer)pSlots.getKey()).intValue(), ((ItemStack)pSlots.getValue()).m_41613_());
            }
            inv.ifPresent(p -> {
                for (Map.Entry map : invSlotMap.entrySet()) {
                    p.insertItem(((Integer)map.getKey()).intValue(), (ItemStack)map.getValue(), false);
                }
            });
            player.m_213846_((Component)Component.m_237110_((String)"message.shop.sell.success", (Object[])new Object[]{Config.getFormattedCurrency(value), EventHandler.getTransItemsDisplayString(transItems)}));
            return;
        }
        if (action.equalsIgnoreCase("server-buy")) {
            double balP = wsd.getBalance(MoneyMod.AcctTypes.PLAYER.key, player.m_20148_());
            if (value > balP) {
                player.m_213846_((Component)Component.m_237115_((String)"message.shop.buy.failure.funds"));
                return;
            }
            wsd.changeBalance(MoneyMod.AcctTypes.PLAYER.key, player.m_20148_(), -value);
            if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                String itemPrint = "";
                itemsList.forEach(a -> itemPrint.concat(a.m_7916_()));
                MoneyMod.dbm.postEntry(System.currentTimeMillis(), DatabaseManager.NIL, MoneyMod.AcctTypes.SERVER.key, "Server", player.m_20148_(), MoneyMod.AcctTypes.PLAYER.key, player.m_7755_().getString(), -value, itemsList.m_7916_());
            }
            for (int i = 0; i < transItems.size(); ++i) {
                ItemStack pStack = ((ItemStack)transItems.get(i)).m_41777_();
                if (player.m_36356_(pStack)) continue;
                player.m_36176_(pStack, false);
            }
            player.m_213846_((Component)Component.m_237110_((String)"message.shop.buy.success", (Object[])new Object[]{EventHandler.getTransItemsDisplayString(transItems), Config.getFormattedCurrency(value)}));
            return;
        }
        if (action.equalsIgnoreCase("server-sell")) {
            HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>();
            for (int t = 0; t < transItems.size(); ++t) {
                int stackSize = ((ItemStack)transItems.get(t)).m_41613_();
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack inSlot = player.m_150109_().m_8020_(i).m_41777_();
                    int count = stackSize > inSlot.m_41613_() ? inSlot.m_41613_() : stackSize;
                    inSlot.m_41764_(count);
                    if (slotMap.containsKey(i) && ((ItemStack)transItems.get(t)).m_41720_().equals(((ItemStack)slotMap.get(i)).m_41720_()) && ItemStack.m_41658_((ItemStack)((ItemStack)transItems.get(t)), (ItemStack)((ItemStack)slotMap.get(i)))) {
                        count = stackSize + ((ItemStack)slotMap.get(i)).m_41613_() > inSlot.m_41613_() ? inSlot.m_41613_() : stackSize + ((ItemStack)slotMap.get(i)).m_41613_();
                        inSlot.m_41764_(count);
                    }
                    if (inSlot.m_41720_().equals(((ItemStack)transItems.get(t)).m_41720_()) && ItemStack.m_41658_((ItemStack)inSlot, (ItemStack)((ItemStack)transItems.get(t)))) {
                        slotMap.merge(i, inSlot, (s, o) -> {
                            s.m_41769_(o.m_41613_());
                            return s;
                        });
                        stackSize -= inSlot.m_41613_();
                    }
                    if (stackSize <= 0) break;
                }
                if (stackSize <= 0) continue;
                player.m_213846_((Component)Component.m_237115_((String)"message.shop.sell.failure.stock"));
                return;
            }
            wsd.changeBalance(MoneyMod.AcctTypes.PLAYER.key, player.m_20148_(), value);
            if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                String itemPrint = "";
                itemsList.forEach(a -> itemPrint.concat(a.m_7916_()));
                MoneyMod.dbm.postEntry(System.currentTimeMillis(), DatabaseManager.NIL, MoneyMod.AcctTypes.SERVER.key, "Server", player.m_20148_(), MoneyMod.AcctTypes.PLAYER.key, player.m_7755_().getString(), value, itemsList.m_7916_());
            }
            for (Map.Entry pSlots : slotMap.entrySet()) {
                player.m_150109_().m_8020_(((Integer)pSlots.getKey()).intValue()).m_41774_(((ItemStack)pSlots.getValue()).m_41613_());
            }
            player.m_213846_((Component)Component.m_237110_((String)"message.shop.sell.success", (Object[])new Object[]{Config.getFormattedCurrency(value), EventHandler.getTransItemsDisplayString(transItems)}));
            return;
        }
    }

    public static enum Shop {
        BUY,
        SELL,
        SERVER_BUY,
        SERVER_SELL;

    }
}

