/*
 * Decompiled with CFR 0.152.
 */
package dicemc.money.compat.ftbquests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dicemc.money.MoneyMod;
import dicemc.money.compat.ftbquests.FTBQHandler;
import dicemc.money.setup.Config;
import dicemc.money.storage.MoneyWSD;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MoneyReward
extends Reward {
    public static RewardType MONEY_REWARD = FTBQHandler.MONEY_REWARD;
    public double amount = 0.0;

    public MoneyReward(Quest q) {
        super(q);
    }

    public RewardType getType() {
        return MONEY_REWARD;
    }

    public void claim(ServerPlayer player, boolean bool) {
        MoneyWSD.get(player.m_20194_().m_129783_()).changeBalance(MoneyMod.AcctTypes.PLAYER.key, player.m_20148_(), this.amount);
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128347_("amount", this.amount);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.amount = nbt.m_128459_("amount");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeDouble(this.amount);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.amount = buffer.readDouble();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addDouble("amount", this.amount, input -> {
            this.amount = input;
        }, 1.0, 0.0, Double.MAX_VALUE);
    }

    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.reward.dicemcmm.moneyreward").m_130946_(" " + (String)Config.CURRENCY_SYMBOL.get() + String.valueOf(this.amount));
    }
}

