/*
 * Decompiled with CFR 0.152.
 */
package dicemc.money.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import dicemc.money.MoneyMod;
import dicemc.money.setup.Config;
import dicemc.money.storage.MoneyWSD;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class AccountCommandTop
implements Command<CommandSourceStack> {
    private static final AccountCommandTop CMD = new AccountCommandTop();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"top").executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Map<UUID, Double> unsorted = MoneyWSD.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).getAccountMap(MoneyMod.AcctTypes.PLAYER.key);
        ArrayList sorted = new ArrayList();
        DecimalFormat df = new DecimalFormat("###,###,###,##0.00");
        unsorted.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(x -> sorted.add(Pair.of((Object)((UUID)x.getKey()), (Object)((Double)x.getValue()))));
        int limit = sorted.size() > (Integer)Config.TOP_SIZE.get() ? ((Integer)Config.TOP_SIZE.get()).intValue() : sorted.size();
        String tkey = limit == 1 ? "message.command.top1" : "message.command.top";
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)tkey, (Object[])new Object[]{limit}), false);
        for (int i = 0; i < limit; ++i) {
            Pair p = (Pair)sorted.get(i);
            String name = ((GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_11002_((UUID)p.getFirst()).get()).getName();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("#" + (i + 1) + " " + name + ": " + Config.getFormattedCurrency(df, (Double)p.getSecond()))), false);
        }
        return 0;
    }
}

