/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.redlimerl.detailab.DetailArmorBar;
import com.redlimerl.detailab.config.ConfigEnumType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class DetailArmorBarConfig {
    private final File file;
    private Options options = null;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public DetailArmorBarConfig(File file) {
        this.file = file;
    }

    public Options getOptions() {
        return this.options;
    }

    public void load() {
        if (this.file.exists()) {
            try {
                this.options = (Options)GSON.fromJson(Files.readString(this.file.toPath(), StandardCharsets.UTF_8), Options.class);
            }
            catch (IOException e) {
                DetailArmorBar.LOGGER.error("Error loading config", (Throwable)e);
            }
            if (this.options != null && this.options.replaceInvalidOptions()) {
                this.save();
            }
        }
        if (this.options == null) {
            this.options = new Options();
            this.save();
        }
    }

    public void save() {
        try {
            Files.writeString(this.file.toPath(), (CharSequence)GSON.toJson((Object)this.options), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            DetailArmorBar.LOGGER.error("Error saving config", (Throwable)e);
        }
    }

    public static class Options {
        public static final Options DEFAULT = new Options();
        public ConfigEnumType.ProtectionEffect effectType = ConfigEnumType.ProtectionEffect.AURA;
        public ConfigEnumType.EffectSpeed effectSpeed = ConfigEnumType.EffectSpeed.NORMAL;
        public ConfigEnumType.Animation effectThorn = ConfigEnumType.Animation.ANIMATION;
        public boolean toggleEnchants = true;
        public boolean toggleNetherites = true;
        public boolean toggleArmorTypes = true;
        public boolean toggleThorns = true;
        public boolean toggleDurability = true;
        public boolean toggleMending = true;
        public boolean toggleEmptyBar = true;
        public boolean toggleItemBar = true;
        public boolean toggleVanillaTexture = true;
        public boolean toggleCompatibleHeartMod = false;
        public boolean toggleInverseSlot = false;
        public boolean toggleSortSpecialItem = true;

        boolean replaceInvalidOptions() {
            boolean invalid = false;
            if (this.effectType == null) {
                this.effectType = Options.DEFAULT.effectType;
                invalid = true;
            }
            if (this.effectSpeed == null) {
                this.effectSpeed = Options.DEFAULT.effectSpeed;
                invalid = true;
            }
            if (this.effectThorn == null) {
                this.effectThorn = Options.DEFAULT.effectThorn;
                invalid = true;
            }
            return invalid;
        }
    }
}

