/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.set;

import java.util.BitSet;

public class BiBitSet {
    protected BitSet postive;
    protected BitSet negative;

    public BiBitSet() {
        this.postive = new BitSet();
        this.negative = new BitSet();
    }

    public BiBitSet(BiBitSet set) {
        this.postive = (BitSet)set.postive.clone();
        this.negative = (BitSet)set.negative.clone();
    }

    public void flip(int bitIndex) {
        if (bitIndex >= 0) {
            this.postive.flip(bitIndex);
        } else {
            this.negative.flip(-1 - bitIndex);
        }
    }

    public void flip(int fromIndex, int toIndex) {
        if (fromIndex >= 0) {
            this.postive.flip(fromIndex, toIndex);
        } else if (toIndex >= 0) {
            this.negative.flip(0, -1 - fromIndex);
            this.postive.flip(0, toIndex);
        } else {
            this.negative.flip(-1 - toIndex, -1 - fromIndex);
        }
    }

    public void set(int bitIndex) {
        if (bitIndex >= 0) {
            this.postive.set(bitIndex);
        } else {
            this.negative.set(-1 - bitIndex);
        }
    }

    public void set(int bitIndex, boolean value) {
        if (bitIndex >= 0) {
            this.postive.set(bitIndex, value);
        } else {
            this.negative.set(-1 - bitIndex, value);
        }
    }

    public void set(int fromIndex, int toIndex) {
        if (fromIndex >= 0) {
            this.postive.set(fromIndex, toIndex);
        } else if (toIndex >= 0) {
            this.negative.set(0, -1 - fromIndex);
            this.postive.set(0, toIndex);
        } else {
            this.negative.set(-1 - toIndex, -1 - fromIndex);
        }
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (fromIndex >= 0) {
            this.postive.set(fromIndex, toIndex, value);
        } else if (toIndex >= 0) {
            this.negative.set(0, -1 - fromIndex, value);
            this.postive.set(0, toIndex, value);
        } else {
            this.negative.set(-1 - toIndex, -1 - fromIndex, value);
        }
    }

    public void clear(int bitIndex) {
        if (bitIndex >= 0) {
            this.postive.clear(bitIndex);
        } else {
            this.negative.clear(-1 - bitIndex);
        }
    }

    public void clear(int fromIndex, int toIndex) {
        if (fromIndex >= 0) {
            this.postive.clear(fromIndex, toIndex);
        } else if (toIndex >= 0) {
            this.negative.clear(0, -1 - fromIndex);
            this.postive.clear(0, toIndex);
        } else {
            this.negative.clear(-1 - toIndex, -1 - fromIndex);
        }
    }

    public void clear() {
        this.postive.clear();
        this.negative.clear();
    }

    public boolean get(int bitIndex) {
        if (bitIndex >= 0) {
            return this.postive.get(bitIndex);
        }
        return this.negative.get(-1 - bitIndex);
    }

    public BitSet get(int fromIndex, int toIndex) {
        if (fromIndex >= 0) {
            return this.postive.get(fromIndex, toIndex);
        }
        if (toIndex >= 0) {
            int i;
            BitSet result = new BitSet(Math.abs(fromIndex) + toIndex + 1);
            int index = 0;
            for (i = fromIndex; i < 0; ++i) {
                result.set(index, this.negative.get(-1 - i));
                ++index;
            }
            for (i = 0; i <= toIndex; ++i) {
                result.set(index, this.postive.get(i));
                ++index;
            }
            return result;
        }
        BitSet result = new BitSet(Math.abs(fromIndex - toIndex));
        int index = 0;
        for (int i = fromIndex; i <= toIndex; ++i) {
            result.set(index, this.negative.get(-1 - i));
            ++index;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.postive.isEmpty() && this.negative.isEmpty();
    }

    public boolean intersects(BiBitSet set) {
        return this.postive.intersects(set.postive) || this.negative.intersects(set.negative);
    }

    public void and(BiBitSet set) {
        this.postive.and(set.postive);
        this.negative.and(set.negative);
    }

    public void or(BiBitSet set) {
        this.postive.or(set.postive);
        this.negative.or(set.negative);
    }

    public void xor(BiBitSet set) {
        this.postive.xor(set.postive);
        this.negative.xor(set.negative);
    }

    public void andNot(BiBitSet set) {
        this.postive.andNot(set.postive);
        this.negative.andNot(set.negative);
    }

    public int hashCode() {
        return this.postive.hashCode() + this.negative.hashCode();
    }

    public int count() {
        int i;
        int count = 0;
        for (i = 0; i < this.postive.length(); ++i) {
            if (!this.postive.get(i)) continue;
            ++count;
        }
        for (i = 0; i < this.negative.length(); ++i) {
            if (!this.negative.get(i)) continue;
            ++count;
        }
        return count;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiBitSet) {
            return ((BiBitSet)obj).postive.equals(this.postive) && ((BiBitSet)obj).negative.equals(this.negative);
        }
        return false;
    }

    public Object clone() {
        return new BiBitSet(this);
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder("{");
        boolean first = true;
        for (i = this.negative.length() - 1; i >= 0; --i) {
            if (!this.negative.get(i)) continue;
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(-i - 1);
        }
        for (i = 0; i < this.postive.length(); ++i) {
            if (!this.postive.get(i)) continue;
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(i);
        }
        result.append("}");
        return result.toString();
    }
}

