/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.filter;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.util.CompoundSerializer;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;
import team.creative.creativecore.common.util.registry.exception.RegistryException;

public class BiFilterSerializer {
    private final NamedTypeRegistry<BiFilter> REGISTRY = new NamedTypeRegistry().addConstructorPattern(CompoundTag.class);

    public <V extends BiFilter & CompoundSerializer> BiFilterSerializer register(String id, Class<V> clazz) {
        this.REGISTRY.register(id, clazz);
        return this;
    }

    public CompoundTag write(BiFilter filter) throws RegistryException {
        if (filter instanceof BiFilter.BiFilterAnd) {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (BiFilter child : ((BiFilter.BiFilterAnd)filter).filters) {
                list.add((Object)this.write(child));
            }
            tag.m_128365_("c", (Tag)list);
            tag.m_128359_("t", "&");
            return tag;
        }
        if (filter instanceof BiFilter.BiFilterOr) {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (BiFilter child : ((BiFilter.BiFilterOr)filter).filters) {
                list.add((Object)this.write(child));
            }
            tag.m_128365_("c", (Tag)list);
            tag.m_128359_("t", "+");
            return tag;
        }
        if (filter instanceof BiFilter.BiFilterNot) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("c", (Tag)this.write(((BiFilter.BiFilterNot)filter).filter));
            tag.m_128359_("t", "!");
            return tag;
        }
        if (filter instanceof CompoundSerializer) {
            CompoundTag tag = ((CompoundSerializer)((Object)filter)).write();
            tag.m_128359_("t", this.REGISTRY.getId(filter));
            return tag;
        }
        throw new RegistryException("Type not registered " + filter.getClass());
    }

    public BiFilter read(CompoundTag tag) throws RegistryException {
        String type = tag.m_128461_("t");
        if (type.equals("&")) {
            ListTag list = tag.m_128437_(type, 10);
            BiFilter[] filters = new BiFilter[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                filters[i] = this.read(list.m_128728_(i));
            }
            return new BiFilter.BiFilterAnd(filters);
        }
        if (type.equals("+")) {
            ListTag list = tag.m_128437_(type, 10);
            BiFilter[] filters = new BiFilter[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                filters[i] = this.read(list.m_128728_(i));
            }
            return new BiFilter.BiFilterOr(filters);
        }
        if (type.equals("!")) {
            return new BiFilter.BiFilterNot(this.read(tag.m_128469_("c")));
        }
        return this.REGISTRY.create(type, tag);
    }
}

