/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.mc.ColorUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiRenderHelper {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static Font getFont() {
        return GuiRenderHelper.mc.f_91062_;
    }

    public static void drawItemStack(PoseStack mat, ItemStack stack, float alpha) {
        boolean flag;
        ItemRenderer renderer = mc.m_91291_();
        mc.m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        PoseStack matrix = RenderSystem.m_157191_();
        matrix.m_85836_();
        matrix.m_166854_(mat.m_85850_().m_85861_());
        matrix.m_85837_(0.0, 0.0, (double)(100.0f + renderer.f_115093_));
        matrix.m_85837_(8.0, 8.0, 0.0);
        matrix.m_85841_(1.0f, -1.0f, 1.0f);
        matrix.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        BakedModel bakedmodel = renderer.m_174264_(stack, (Level)null, (LivingEntity)null, 0);
        boolean bl = flag = !bakedmodel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        renderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, new PoseStack(), (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        matrix.m_85849_();
        RenderSystem.m_157182_();
    }

    public static void drawItemStackDecorations(PoseStack posestack, ItemStack stack) {
        GuiRenderHelper.drawItemStackDecorations(posestack, stack, stack.m_41613_());
    }

    public static void drawItemStackDecorations(PoseStack posestack, ItemStack stack, int count) {
        if (!stack.m_41619_()) {
            LocalPlayer localplayer;
            float f;
            int x = 0;
            int y = 0;
            if ((long)count != 1L) {
                String s = String.valueOf(count);
                posestack.m_85837_(0.0, 0.0, 200.0);
                MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                GuiRenderHelper.mc.f_91062_.m_92811_(s, (float)(x + 19 - 2 - GuiRenderHelper.mc.f_91062_.m_92895_(s)), (float)(y + 6 + 3), 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)multibuffersource$buffersource, false, 0, 0xF000F0);
                multibuffersource$buffersource.m_109911_();
            }
            if (stack.m_150947_()) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69461_();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                int i = stack.m_150948_();
                int j = stack.m_150949_();
                GuiRenderHelper.colorRect(posestack, bufferbuilder, x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                GuiRenderHelper.colorRect(posestack, bufferbuilder, x + 2, y + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.m_69478_();
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
            float f2 = f = (localplayer = Minecraft.m_91087_().f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
            if (f > 0.0f) {
                RenderSystem.m_69465_();
                RenderSystem.m_69472_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                Tesselator tesselator1 = Tesselator.m_85913_();
                BufferBuilder bufferbuilder1 = tesselator1.m_85915_();
                GuiRenderHelper.colorRect(posestack, bufferbuilder1, x, y + Mth.m_14143_((float)(16.0f * (1.0f - f))), 16, Mth.m_14167_((float)(16.0f * f)), 255, 255, 255, 127);
                RenderSystem.m_69493_();
                RenderSystem.m_69482_();
            }
        }
    }

    public static void drawStringCentered(PoseStack stack, String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        int textWidth = GuiRenderHelper.mc.f_91062_.m_92895_((String)text);
        if ((float)textWidth > width && textWidth > (dotWith = GuiRenderHelper.mc.f_91062_.m_92895_("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < ((String)text).length() && (float)((charWidth = GuiRenderHelper.mc.f_91062_.m_92895_("" + ((String)text).charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(((String)text).charAt(i));
                textWidth += charWidth;
            }
            text = builder.toString() + "...";
        }
        Font font = GuiRenderHelper.mc.f_91062_;
        float f = width / 2.0f - (float)(GuiRenderHelper.mc.f_91062_.m_92895_((String)text) / 2);
        float f2 = height / 2.0f;
        Objects.requireNonNull(GuiRenderHelper.mc.f_91062_);
        font.m_92750_(stack, (String)text, f, f2 - (float)(9 / 2), color);
    }

    public static void horizontalGradientRect(PoseStack pose, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiRenderHelper.horizontalGradientRect(pose.m_85850_().m_85861_(), bufferbuilder, x, y, x2, y2, 0, colorFrom, colorTo);
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void horizontalGradientRect(Matrix4f matrix, BufferBuilder builder, int x, int y, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.m_85982_(matrix, (float)x2, (float)y, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
        builder.m_85982_(matrix, (float)x, (float)y, (float)z).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x, (float)y2, (float)z).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x2, (float)y2, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
    }

    public static void verticalGradientRect(PoseStack pose, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiRenderHelper.verticalGradientRect(pose.m_85850_().m_85861_(), bufferbuilder, x, y, x2, y2, 0, colorFrom, colorTo);
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void verticalGradientRect(Matrix4f matrix, BufferBuilder builder, int x, int y, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.m_85982_(matrix, (float)x2, (float)y, (float)z).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x, (float)y, (float)z).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x, (float)y2, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
        builder.m_85982_(matrix, (float)x2, (float)y2, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
    }

    public static void horizontalGradientMaskRect(PoseStack pose, int x, int y, int x2, int y2, int color, int mask) {
        GuiRenderHelper.horizontalGradientRect(pose, x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    public static void colorRect(PoseStack pose, int x, int y, int width, int height, int color) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        GuiRenderHelper.colorRect(pose, Tesselator.m_85913_().m_85915_(), x, y, x + width, y + height, ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), ColorUtils.alpha(color));
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void colorRect(PoseStack pose, BufferBuilder builder, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        Matrix4f mat = pose.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_85982_(mat, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(mat, (float)x, (float)(y + height), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(mat, (float)(x + width), (float)(y + height), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(mat, (float)(x + width), (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    private static void textureRect(PoseStack pose, int x, int y, int z, int width, int height, float u, float v, int textureWidth, int textureHeight) {
        GuiRenderHelper.textureRect(pose, x, x + width, y, y + height, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void textureRect(PoseStack pose, int x, int y, int width, int height, float u, float v) {
        GuiRenderHelper.textureRect(pose, x, y, 0, width, height, u, v, 256, 256);
    }

    public static void textureRect(PoseStack pose, int x, int y, int width, int height, float u, float v, float u2, float v2) {
        GuiRenderHelper.textureRect(pose, x, x + width, y, y + height, 0, u, v, u2, v2, 256, 256);
    }

    private static void textureRect(PoseStack pose, int x, int x2, int y, int y2, int z, float u, float v, float u2, float v2, int textureWidth, int textureHeight) {
        GuiRenderHelper.drawTextureRect(pose.m_85850_().m_85861_(), x, x2, y, y2, z, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight);
    }

    private static void textureRect(PoseStack pose, int x, int x2, int y, int y2, int z, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        GuiRenderHelper.drawTextureRect(pose.m_85850_().m_85861_(), x, x2, y, y2, z, u / (float)textureWidth, (u + (float)uWidth) / (float)textureWidth, v / (float)textureHeight, (v + (float)vHeight) / (float)textureHeight);
    }

    private static void drawTextureRect(Matrix4f matrix, int x, int x2, int y, int y2, int z, float u, float u2, float v, float v2) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, (float)x, (float)y2, (float)z).m_7421_(u, v2).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x2, (float)y2, (float)z).m_7421_(u2, v2).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x2, (float)y, (float)z).m_7421_(u2, v).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)x, (float)y, (float)z).m_7421_(u, v).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }
}

