/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.plugins.conplugin.config;

import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import pregenerator.common.utils.config.Config;
import pregenerator.common.utils.config.ConfigHandler;
import pregenerator.plugins.conplugin.config.IConfigSyncer;
import pregenerator.plugins.conplugin.config.SimpleConfigRoot;

public class SimpleModConfig
implements IModConfig {
    ConfigType type;
    ConfigHandler handler;
    Config config;
    String modId;
    IConfigEntry root;

    public SimpleModConfig(ConfigHandler handler, String modId) {
        this(handler, modId, ConfigType.UNIVERSAL);
    }

    public SimpleModConfig(ConfigHandler handler, String modId, ConfigType type) {
        this.handler = handler;
        this.config = handler.getConfig();
        this.modId = modId;
        this.type = type;
        this.root = new SimpleConfigRoot(this.config);
    }

    private void processChanges(IConfigEntry myRoot, Consumer<IConfigSyncer> processor) {
        if (myRoot.isLeaf()) {
            IConfigValue value = myRoot.getValue();
            if (value == null) {
                return;
            }
            if (!value.isChanged()) {
                return;
            }
            if (value instanceof IConfigSyncer) {
                IConfigSyncer sync = (IConfigSyncer)value;
                processor.accept(sync);
            }
            return;
        }
        for (IConfigEntry entry : myRoot.getChildren()) {
            this.processChanges(entry, processor);
        }
    }

    public String getFileName() {
        return this.config.getName().concat(".cfg");
    }

    public String getModId() {
        return this.modId;
    }

    public IConfigEntry getRoot() {
        return this.root;
    }

    public ConfigType getType() {
        return this.type;
    }

    public void loadWorldConfig(Path path, Consumer<IModConfig> result) throws IOException {
    }

    public void stopEditing() {
        this.processChanges(this.root, IConfigSyncer::reset);
    }

    public void update(IConfigEntry entry) {
        this.processChanges(this.root, IConfigSyncer::update);
        this.handler.save();
        this.handler.onSynced();
    }

    public boolean isChanged() {
        return this.config.hasChanged();
    }

    public void restoreDefaults() {
        this.config.resetDefault();
    }
}

