/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.plugins;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import pregenerator.ChunkPregenerator;
import pregenerator.common.utils.config.ConfigSection;
import pregenerator.common.utils.plugins.IPlugin;
import pregenerator.common.utils.plugins.IPregenPlugin;

public class PluginLoader {
    Map<String, IPlugin> modules = new Object2ObjectLinkedOpenHashMap();

    public void init(ConfigSection section) {
        for (Module entry : this.getClasses()) {
            IPlugin module = entry.getModule();
            if (!module.canLoad(FMLEnvironment.dist) || !section.addBool(entry.getPlugin().id(), true).get()) continue;
            this.modules.put(entry.getPlugin().id(), entry.getModule());
        }
    }

    public void fireEvent(Consumer<IPlugin> module) {
        this.modules.values().forEach(module);
    }

    public IPlugin getModule(String id) {
        return this.modules.get(id);
    }

    private List<Module> getClasses() {
        Type type = Type.getType(IPregenPlugin.class);
        ObjectArrayList lists = new ObjectArrayList();
        for (ModFileScanData mod : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData data : mod.getAnnotations()) {
                if (!data.annotationType().equals((Object)type)) continue;
                try {
                    Class<?> clz = Class.forName(data.memberName());
                    if (clz == null) continue;
                    IPregenPlugin plug = clz.getAnnotation(IPregenPlugin.class);
                    ChunkPregenerator.LOGGER.info("Loading Plugin: [name=" + plug.name() + "]");
                    IPlugin module = (IPlugin)clz.newInstance();
                    if (module == null) continue;
                    lists.add(new Module(plug, module));
                }
                catch (Exception exception) {}
            }
        }
        return lists;
    }

    static class Module {
        IPregenPlugin plugin;
        IPlugin module;

        public Module(IPregenPlugin plugin, IPlugin module) {
            this.plugin = plugin;
            this.module = module;
        }

        public IPlugin getModule() {
            return this.module;
        }

        public IPregenPlugin getPlugin() {
            return this.plugin;
        }
    }
}

