/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import pregenerator.base.mixins.common.storage.ChunkManagerMixin;
import pregenerator.base.mixins.common.storage.RegionSectionCacheMixin;
import pregenerator.common.tracker.TypeEntry;
import pregenerator.common.utils.misc.AverageCounter;
import pregenerator.common.utils.misc.TimeTracker;

public class WorldTracker {
    ServerLevel world;
    TimeTracker timer = new TimeTracker(40);
    AverageCounter blockUpdates = new AverageCounter(40);
    AverageCounter blockTicks = new AverageCounter(40);
    AverageCounter fluidTicks = new AverageCounter(40);
    TimeTracker averageLag = new TimeTracker(200);
    Long2ObjectMap<Optional<PoiSection>> pointsOfInterest;
    int loadedEntities = 0;
    int loadedBlockEntities = 0;
    int loadedTickingBlockEntities = 0;

    public WorldTracker(ServerLevel world) {
        this.world = world;
        this.pointsOfInterest = ((RegionSectionCacheMixin)world.m_8904_()).getStorage();
        if (this.pointsOfInterest == null) {
            this.pointsOfInterest = new Long2ObjectOpenHashMap();
        }
    }

    public ServerLevel getWorld() {
        return this.world;
    }

    public void start() {
        Object2IntMap state;
        this.timer.start();
        this.blockTicks.addMore(this.world.m_183326_().m_183574_());
        this.blockTicks.onFinished();
        this.fluidTicks.addMore(this.world.m_183324_().m_183574_());
        this.fluidTicks.onFinished();
        this.loadedEntities = 0;
        this.averageLag.start();
        if (this.world.m_46467_() % 20L == 0L) {
            this.loadedBlockEntities = 0;
            this.loadedTickingBlockEntities = 0;
            TypeEntry.getBlockEntities(this.world, this::countTile);
        }
        this.averageLag.finish();
        NaturalSpawner.SpawnState spawnState = this.world.m_7726_().m_8485_();
        if (spawnState != null && (state = spawnState.m_47148_()) != null) {
            IntIterator intIterator = state.values().iterator();
            while (intIterator.hasNext()) {
                int value = (Integer)intIterator.next();
                this.loadedEntities += value;
            }
        }
    }

    private void countTile(BlockEntity entity) {
        ++this.loadedBlockEntities;
        this.loadedTickingBlockEntities += entity.m_58900_().m_155944_((Level)this.world, entity.m_58903_()) != null ? 1 : 0;
    }

    public void stop() {
        this.timer.finish();
        this.blockUpdates.onFinished();
    }

    public void onBlockUpdate() {
        this.blockUpdates.addOne();
    }

    public long getAverageLag() {
        return this.timer.getAverage();
    }

    public List<LevelChunk> getChunks() {
        ObjectArrayList chunks = new ObjectArrayList();
        for (ChunkHolder holder : ((ChunkManagerMixin)this.world.m_7726_().f_8325_).getLoadedChunks()) {
            Optional entry = holder.m_140073_().getNow(ChunkHolder.f_139997_).left();
            if (!entry.isPresent()) continue;
            chunks.add((LevelChunk)entry.get());
        }
        return chunks;
    }

    public LevelChunk getChunk(long chunkPos) {
        return this.world.m_6325_(ChunkPos.m_45592_((long)chunkPos), ChunkPos.m_45602_((long)chunkPos));
    }

    public void writeTrackingData(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.world.m_46472_().m_135782_());
        buffer.m_130103_(this.timer.getAverage());
        buffer.m_130103_(this.timer.getLastValue());
        buffer.m_130130_(this.loadedBlockEntities);
        buffer.m_130130_(this.loadedTickingBlockEntities);
        buffer.m_130130_(this.world.m_7726_().m_8482_());
        buffer.m_130130_(this.pointsOfInterest.size());
        buffer.m_130130_(this.loadedEntities);
        buffer.m_130130_(this.blockUpdates.getAverage());
        buffer.m_130130_(this.blockUpdates.getLast());
        buffer.m_130130_(this.blockTicks.getAverage());
        buffer.m_130130_(this.blockTicks.getLast());
        buffer.m_130130_(this.fluidTicks.getAverage());
        buffer.m_130130_(this.fluidTicks.getLast());
    }
}

