/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SeedManager {
    public static final SeedManager INSTANCE = new SeedManager();
    boolean loaded = false;
    Object2LongMap<ResourceLocation> seeds = new Object2LongOpenHashMap();
    Object2LongMap<ResourceLocation> structureSeeds = new Object2LongOpenHashMap();

    public void onServerStopping(ServerStoppingEvent event) {
        this.loaded = false;
        this.seeds.clear();
        this.structureSeeds.clear();
    }

    public long getSeed(ResourceKey<Level> level, long originalSeed) {
        this.loadSeeds();
        if (this.seeds.containsKey((Object)level.m_135782_())) {
            return BiomeManager.m_47877_((long)this.seeds.getLong((Object)level.m_135782_()));
        }
        return originalSeed;
    }

    public long getStructureSeed(ResourceKey<Level> level, long originalSeed) {
        this.loadSeeds();
        return this.structureSeeds.getOrDefault((Object)level.m_135782_(), originalSeed);
    }

    public void mergeSeeds(Map<ResourceLocation, String> seeds, Path path) {
        for (Map.Entry<ResourceLocation, String> entry : seeds.entrySet()) {
            long seed = SeedManager.makeSeed(entry.getValue());
            this.seeds.put((Object)entry.getKey(), seed);
            this.structureSeeds.put((Object)entry.getKey(), seed);
        }
        this.saveSeeds(path);
        this.seeds.clear();
        this.structureSeeds.clear();
        this.loaded = false;
    }

    private void loadSeeds() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        Path path = this.getPath();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonObject data;
                JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (JsonElement el : obj.getAsJsonArray("level_seeds")) {
                    data = el.getAsJsonObject();
                    this.seeds.put((Object)ResourceLocation.m_135820_((String)data.get("dim").getAsString()), data.get("seed").getAsLong());
                }
                for (JsonElement el : obj.getAsJsonArray("structure_seeds")) {
                    data = el.getAsJsonObject();
                    this.structureSeeds.put((Object)ResourceLocation.m_135820_((String)data.get("dim").getAsString()), data.get("seed").getAsLong());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            WorldGenSettings settings = ServerLifecycleHooks.getCurrentServer().m_129910_().m_5961_();
            long seed = settings.m_64619_();
            for (ResourceKey key : settings.m_64667_()) {
                this.seeds.putIfAbsent((Object)key.m_135782_(), seed);
                this.structureSeeds.putIfAbsent((Object)key.m_135782_(), seed);
            }
            this.saveSeeds(this.getPath());
        }
    }

    private void saveSeeds(Path path) {
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));){
            JsonObject obj;
            JsonArray seedObj = new JsonArray();
            JsonArray structureSeedObj = new JsonArray();
            for (Object2LongMap.Entry entry : this.seeds.object2LongEntrySet()) {
                obj = new JsonObject();
                obj.addProperty("dim", ((ResourceLocation)entry.getKey()).toString());
                obj.addProperty("seed", (Number)entry.getLongValue());
                seedObj.add((JsonElement)obj);
            }
            for (Object2LongMap.Entry entry : this.structureSeeds.object2LongEntrySet()) {
                obj = new JsonObject();
                obj.addProperty("dim", ((ResourceLocation)entry.getKey()).toString());
                obj.addProperty("seed", (Number)entry.getLongValue());
                structureSeedObj.add((JsonElement)obj);
            }
            JsonObject obj2 = new JsonObject();
            obj2.add("level_seeds", (JsonElement)seedObj);
            obj2.add("structure_seeds", (JsonElement)structureSeedObj);
            writer.setIndent("\t");
            Streams.write((JsonElement)obj2, (JsonWriter)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Path getPath() {
        return ServerLifecycleHooks.getCurrentServer().m_129843_(new LevelResource("serverconfig")).resolve("pregen_seeds.json");
    }

    public static long makeSeed(String input) {
        try {
            return !StringUtil.m_14408_((String)input) ? Long.parseLong(input) : 0L;
        }
        catch (NumberFormatException var7) {
            return input.hashCode();
        }
    }
}

