/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public abstract class BaseTask
implements ITask {
    String name;
    ResourceKey<Level> type;
    int genType;
    UUID task = UUID.randomUUID();
    UUID owner;
    boolean throwEvents = true;

    public BaseTask(CompoundTag nbt) {
        this(nbt.m_128461_("name"), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dim"))), nbt.m_128451_("genType"));
        this.throwEvents = nbt.m_128471_("events");
        if (nbt.m_128403_("taskId")) {
            this.task = nbt.m_128342_("taskId");
        }
        if (nbt.m_128403_("owner")) {
            this.owner = nbt.m_128342_("owner");
        }
    }

    public BaseTask(String name, ResourceKey<Level> type, int genType) {
        this.name = name;
        this.type = type;
        this.genType = genType;
    }

    @Override
    public void setOwner(UUID id) {
        this.owner = id;
    }

    public BaseTask setThrowEvents() {
        this.throwEvents = true;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.type;
    }

    @Override
    public int getGenType() {
        return this.genType;
    }

    @Override
    public UUID getTaskId() {
        return this.task;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public MutableComponent getTaskDescription() {
        MutableComponent text = Component.m_237113_((String)"[");
        ITask.convert("Name=" + this.getName() + ", ", text, ChatFormatting.AQUA);
        ITask.convert("Dim=" + this.getDimension().m_135782_().m_135815_() + ", ", text, ChatFormatting.GREEN);
        ITask.convert("GenType=" + GenerationType.values()[this.genType].name() + ", ", text, new ChatFormatting[0]);
        this.append(text);
        return text.m_130946_("]");
    }

    public abstract void append(MutableComponent var1);

    @Override
    public boolean isValid() {
        return this.type != null;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("name", this.name);
        nbt.m_128359_("dim", this.type.m_135782_().toString());
        nbt.m_128344_("genType", (byte)this.genType);
        nbt.m_128362_("taskId", this.task);
        if (this.throwEvents) {
            nbt.m_128379_("events", this.throwEvents);
        }
        if (this.owner != null) {
            nbt.m_128362_("owner", this.owner);
        }
        return nbt;
    }

    @Override
    public void onCompletion(Duration terrainTime, Duration lightTime, long totalChunks) {
    }

    @Override
    public CompletableFuture<ChunkProcess> createTask(ServerLevel world, Executor exe, IProcess.PrepaireProgress progress) {
        return CompletableFuture.supplyAsync(() -> this.createTask(world, progress), exe);
    }

    public abstract ChunkProcess createTask(ServerLevel var1, IProcess.PrepaireProgress var2);
}

