/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import pregenerator.common.commands.arguments.ISuggestableEnum;
import pregenerator.common.generator.ChunkEntry;
import pregenerator.common.generator.ChunkProcess;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GenerationType implements ISuggestableEnum
{
    TERRAIN_ONLY(0){

        @Override
        public boolean hasSubTask() {
            return false;
        }
    }
    ,
    FAST_CHECK_GEN(1),
    NORMAL_GEN(2, true),
    POST_GEN(3, true),
    BLOCK_POST(4),
    RETROGEN(5, true){

        @Override
        public boolean hasSubTask() {
            return false;
        }

        @Override
        public void startMainTask(long[] chunks, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>[] tasks, ChunkEntry entry, ChunkProcess task) {
            task.startTask(chunks, 8, tasks);
            ObjectArrayList list = new ObjectArrayList();
            for (int i = 0; i < tasks.length; ++i) {
                ChunkPos pos = new ChunkPos(chunks[i]);
                for (int k = -8; k <= 8; ++k) {
                    for (int l = -8; l <= 8; ++l) {
                        list.add(task.getChunk(ChunkPos.m_45589_((int)(pos.f_45578_ + l), (int)(pos.f_45579_ + k))));
                    }
                }
            }
            entry.setRetrogenTask(CompletableFuture.allOf(list.toArray(new CompletableFuture[list.size()])));
        }

        @Override
        public void unloadMainTask(long[] chunks, int min, int max, ChunkProcess task) {
            task.finishTickets(chunks, min, max, 8);
        }

        @Override
        public void startSubTask(long[] chunks, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>[] tasks, ChunkProcess task) {
        }

        @Override
        public void unloadSubTask(long[] chunks, int min, int max, ChunkProcess task) {
        }
    };

    int index;
    boolean accurate;

    private GenerationType(int index, boolean accurate) {
        this.index = index;
        this.accurate = accurate;
    }

    private GenerationType(int index) {
        this.index = index;
        this.accurate = false;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean requiresAccurateScan() {
        return this.accurate;
    }

    @Override
    public Component createSuggestion() {
        switch (this) {
            case BLOCK_POST: {
                return Component.m_237113_((String)"Generates Only the Terrain and Tricks the game into thinking they are fully finished");
            }
            case FAST_CHECK_GEN: {
                return Component.m_237113_((String)"Generates Chunks normally, but with simplifed chunk checks, 100x faster, but 95% accurate");
            }
            case NORMAL_GEN: {
                return Component.m_237113_((String)"Generates Chunks normally and makes deep checks they are fully finished");
            }
            case POST_GEN: {
                return Component.m_237113_((String)"Makes sure that already generated Chunks are fully generated");
            }
            case RETROGEN: {
                return Component.m_237113_((String)"Regenerates Selected Features in already generated Chunks");
            }
            case TERRAIN_ONLY: {
                return Component.m_237113_((String)"Only Generates the Terrain");
            }
        }
        return Component.m_237113_((String)"I AM ERROR");
    }

    public boolean hasSubTask() {
        return true;
    }

    public void startMainTask(long[] chunks, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>[] tasks, ChunkEntry entry, ChunkProcess task) {
        task.startTask(chunks, this == TERRAIN_ONLY || this == BLOCK_POST ? ChunkStatus.f_62321_ : ChunkStatus.f_62322_, tasks);
    }

    public void startSubTask(long[] chunks, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>[] tasks, ChunkProcess task) {
        task.startTask(chunks, ChunkStatus.f_62326_, tasks);
        task.finishTickets(chunks, 0, chunks.length, this == TERRAIN_ONLY || this == BLOCK_POST ? ChunkStatus.f_62321_ : ChunkStatus.f_62322_);
    }

    public void unloadMainTask(long[] chunks, int min, int max, ChunkProcess task) {
        task.finishTickets(chunks, min, max, this == TERRAIN_ONLY || this == BLOCK_POST ? ChunkStatus.f_62321_ : ChunkStatus.f_62322_);
    }

    public void unloadSubTask(long[] chunks, int min, int max, ChunkProcess task) {
        task.finishTickets(chunks, min, max, ChunkStatus.f_62326_);
    }
}

