/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.BitSet;
import java.util.Optional;
import java.util.function.LongPredicate;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.dimension.DimensionType;
import pregenerator.base.mixins.common.storage.RegionSectionCacheMixin;
import pregenerator.common.base.IInteruptable;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.collections.Long2ObjectCustomMap;

public class ChunkDeleter
implements IInteruptable {
    private ResourceKey<Level> type;
    private Path worldFile;
    private ServerLevel world;
    private Long2ObjectLinkedOpenHashMap<RegionFile> chunkCache;
    private Long2ObjectLinkedOpenHashMap<RegionFile> poiCache;
    private ServerChunkCache provider;
    private LongPredicate predicate = T -> ChunkProcess.getHolder(this.provider, ChunkPos.m_45589_((int)SectionPos.m_123213_((long)T), (int)SectionPos.m_123230_((long)T))) == null;
    private Long2ObjectMap<Optional<PoiSection>> pointsOfInterest;
    private long totalChunks = 0L;
    private ObjectArrayList<DeleterEntry> entries = ObjectArrayList.wrap((Object[])new DeleterEntry[0]);

    public ChunkDeleter(ResourceKey<Level> type, Path worldFile, ServerLevel world) {
        this.type = type;
        this.worldFile = DimensionType.m_196975_(type, (Path)worldFile);
        this.world = world;
        if (this.world != null) {
            this.provider = world.m_7726_();
            this.chunkCache = this.getCache(this.provider);
            this.poiCache = this.getCache(this.provider.m_8484_());
            Long2ObjectMap map = ((RegionSectionCacheMixin)this.provider.m_8484_()).getStorage();
            if (map instanceof Long2ObjectCustomMap) {
                this.pointsOfInterest = map;
            } else {
                this.pointsOfInterest = new Long2ObjectCustomMap(map);
                ((RegionSectionCacheMixin)this.provider.m_8484_()).setStorage(this.pointsOfInterest);
            }
        }
    }

    public ChunkDeleter init(Long2ObjectMap<BitSet> maps, ChunkPos center, IProcess.PrepaireProgress progress) {
        if (!progress.isAlive()) {
            return this;
        }
        progress.growMax(maps.size());
        this.entries.ensureCapacity(maps.size());
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(maps)) {
            progress.growValue(1);
            DeleterEntry delete = new DeleterEntry(this, new ChunkPos(ChunkPos.m_45592_((long)entry.getLongKey()) << 5, ChunkPos.m_45602_((long)entry.getLongKey()) << 5), (BitSet)entry.getValue());
            if (!delete.canDelete()) continue;
            this.entries.add((Object)delete);
            this.totalChunks += (long)((BitSet)entry.getValue()).cardinality();
        }
        ObjectArrays.parallelQuickSort((Object[])((DeleterEntry[])this.entries.elements()), (int)0, (int)this.entries.size(), (o1, o2) -> Long.compare(o2.getDistanceToCenter(center), o1.getDistanceToCenter(center)));
        return this;
    }

    public ResourceKey<Level> getType() {
        return this.type;
    }

    public void start() {
        if (this.world == null) {
            return;
        }
        this.provider.m_8419_(true);
        this.pointsOfInterest.keySet().removeIf(this.predicate);
        ObjectArrayList list = new ObjectArrayList(this.chunkCache.values());
        this.chunkCache.clear();
        for (RegionFile file : list) {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
        list = new ObjectArrayList(this.poiCache.values());
        this.poiCache.clear();
        for (RegionFile file : list) {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
    }

    public DeleterEntry getNextTask() {
        return this.entries.isEmpty() ? null : (DeleterEntry)this.entries.pop();
    }

    public boolean isDone() {
        return this.entries.isEmpty();
    }

    public long getTotal() {
        return this.totalChunks;
    }

    @Override
    public void interrupt() {
        this.entries.clear();
    }

    protected boolean canDelete(int x, int z) {
        return this.provider == null || !this.provider.m_5563_(x, z);
    }

    static class DeleterEntry {
        ChunkDeleter owner;
        ChunkPos position;
        BitSet toDelete;
        int size;
        int skipped;
        int removed;

        public DeleterEntry(ChunkDeleter owner, ChunkPos position, BitSet toDelete) {
            this.owner = owner;
            this.position = position;
            this.toDelete = toDelete;
            this.size = toDelete.cardinality();
        }

        public boolean canDelete() {
            return Files.exists(this.owner.worldFile.resolve("region/r." + (this.position.f_45578_ >> 5) + "." + (this.position.f_45579_ >> 5) + ".mca"), new LinkOption[0]);
        }

        long getDistanceToCenter(ChunkPos center) {
            long x = this.position.f_45578_ - center.f_45578_;
            long z = this.position.f_45579_ - center.f_45579_;
            return x * x + z * z;
        }

        public int size() {
            return this.size;
        }

        public int getRemoved() {
            return this.removed;
        }

        public int getSkipped() {
            return this.skipped;
        }

        public void update() {
            String pos = "r." + (this.position.f_45578_ >> 5) + "." + (this.position.f_45579_ >> 5) + ".mca";
            Path chunkFolder = this.owner.worldFile.resolve("region");
            Path poiFolder = this.owner.worldFile.resolve("poi");
            Path chunkFile = chunkFolder.resolve(pos);
            Path poiFile = poiFolder.resolve(pos);
            if (this.size == 1024) {
                try {
                    Files.deleteIfExists(chunkFile);
                    Files.deleteIfExists(poiFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.removed = this.size;
                return;
            }
            try {
                this.removed = 0;
                Path tempChunk = this.owner.worldFile.resolve("region/temp.mca");
                Path tempPoi = this.owner.worldFile.resolve("poi/temp.mca");
                Files.move(chunkFile, tempChunk, StandardCopyOption.REPLACE_EXISTING);
                Files.move(poiFile, tempPoi, StandardCopyOption.REPLACE_EXISTING);
                RegionFile oldChunk = new RegionFile(tempChunk, tempChunk.getParent(), false);
                RegionFile oldPoi = new RegionFile(tempPoi, tempPoi.getParent(), false);
                RegionFile newChunk = new RegionFile(chunkFile, chunkFolder, false);
                RegionFile newPoi = new RegionFile(poiFile, poiFolder, false);
                int stored = 0;
                for (int i = 0; i < 1024; ++i) {
                    ChunkPos entry = new ChunkPos(i % 32, i / 32);
                    if (!(this.toDelete.get(i) && this.owner.canDelete(this.position.f_45578_ + entry.f_45578_, this.position.f_45579_ + entry.f_45579_) || !oldChunk.m_63682_(entry))) {
                        try {
                            DataOutputStream out;
                            DataInputStream read = oldChunk.m_63645_(entry);
                            if (read != null) {
                                out = newChunk.m_63678_(entry);
                                this.copy(read, out);
                                out.close();
                            }
                            if ((read = oldPoi.m_63645_(entry)) != null) {
                                out = newPoi.m_63678_(entry);
                                this.copy(read, out);
                                out.close();
                            }
                            ++stored;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    ++this.removed;
                }
                this.removed = Math.min(this.removed, this.size - this.skipped);
                oldChunk.close();
                newChunk.close();
                oldPoi.close();
                newPoi.close();
                if (stored == 0) {
                    Files.delete(chunkFile);
                    Files.delete(poiFile);
                }
                Files.delete(tempChunk);
                Files.delete(tempPoi);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public long copy(InputStream input, OutputStream output) throws IOException {
            byte[] buffer = new byte[8192];
            int n = 0;
            long count = 0L;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            return count;
        }
    }
}

