/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import pregenerator.PregenConfig;
import pregenerator.base.mixins.client.WorldOptionsScreenMixin;
import pregenerator.client.ProcessorRenderer;
import pregenerator.client.gui.MissingScreen;
import pregenerator.client.gui.PregenScreen;

public class ClientHandler {
    public static final ClientHandler INSTANCE = new ClientHandler();
    public ProcessorRenderer processor = new ProcessorRenderer();
    @OnlyIn(value=Dist.CLIENT)
    KeyMapping uiKey;

    public void onInfoPacketReceived(byte[] data) {
        this.processor.onInfoPacketReceived(data);
    }

    public void addFunctions(IEventBus bus) {
        bus.addListener(this::registerKeys);
        bus.addListener(this::registerOverlay);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerKeys(RegisterKeyMappingsEvent event) {
        this.uiKey = new KeyMapping("Options Gui", 73, "Chunk-Pregenerator");
        event.register(this.uiKey);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onGuiOpened(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreateWorldScreen) {
            final CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            if (!ModList.get().isLoaded("pregen_expansion") && PregenConfig.INSTANCE.info.get()) {
                int width = event.getScreen().f_96543_ / 2;
                event.addListener((GuiEventListener)new ExtendedButton(width + 5, 132, 150, 18, (Component)Component.m_237113_((String)"Preview").m_130940_(ChatFormatting.GOLD), T -> Minecraft.m_91087_().m_91152_((Screen)new MissingScreen((Screen)screen2))){

                    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                        boolean visible = ((WorldOptionsScreenMixin)screen2.f_100847_).getBonusItemButton().f_93624_;
                        this.f_93621_ = visible ? 151 : 132;
                        this.f_93619_ = visible ? 20 : 18;
                        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyPressed(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (this.uiKey.m_90857_() && mc.f_91080_ == null) {
            mc.m_91152_((Screen)new PregenScreen());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("pregen_overlays", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
            this.processor.onUIRenderer(poseStack);
            GlStateManager.m_84513_();
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onUIUpdate(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        this.processor.update();
    }
}

