/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.content.gui.menus;

import com.tynoxs.buildersdelight.content.init.BdContainers;
import com.tynoxs.buildersdelight.content.init.BdSounds;
import com.tynoxs.buildersdelight.content.recipe.ChiselRecipeFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ContainerChisel
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private Container chisel;
    private ChiselRecipeFactory recipeFactory = ChiselRecipeFactory.get();
    private boolean toggle;
    private List<Slot> variantsSlots = new ArrayList<Slot>();
    private Inventory pPlayerInventory;

    public ContainerChisel(int id, Inventory inv, FriendlyByteBuf friendlyByteBuf) {
        this(id, inv, ContainerLevelAccess.f_39287_, new SimpleContainer(30));
    }

    public ContainerChisel(int id, Inventory pPlayerInventory, ContainerLevelAccess access, SimpleContainer pContainer) {
        super((MenuType)BdContainers.CHISEL_CONTAINER.get(), id);
        this.chisel = pContainer;
        this.pPlayerInventory = pPlayerInventory;
        pContainer.m_5856_(pPlayerInventory.f_35978_);
        this.access = access;
        int index = 0;
        this.inputSlot = this.m_38897_(new Slot((Container)pContainer, index, 28, 18){

            public boolean m_5857_(ItemStack pStack) {
                return true;
            }

            public void m_6654_() {
                super.m_6654_();
                ItemStack itemstack = ContainerChisel.this.inputSlot.m_7993_();
                ContainerChisel.this.updateVariants(itemstack);
            }
        });
        this.resultSlot = this.m_38897_(new Slot((Container)pContainer, ++index, 28, 45){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        ++index;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                Slot slot = new Slot((Container)pContainer, index, 55 + j * 18, 18 + i * 18){

                    public boolean m_5857_(ItemStack pStack) {
                        return false;
                    }

                    public boolean m_8010_(Player pPlayer) {
                        if (!ContainerChisel.this.resultSlot.m_6657_()) {
                            ContainerChisel.this.craftVariant(this.m_7993_());
                            Level world = pPlayer.f_19853_;
                            if (!world.f_46443_) {
                                world.m_6269_(null, (Entity)pPlayer, (SoundEvent)BdSounds.CHISELING_SOUND.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            }
                        }
                        return false;
                    }
                };
                this.variantsSlots.add(slot);
                this.m_38897_(slot);
                ++index;
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)pPlayerInventory, i1 + k * 9 + 9, 20 + i1 * 18, 114 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)pPlayerInventory, l, 20 + l * 18, 172));
        }
    }

    private void updateVariants(ItemStack input) {
        if (input == ItemStack.f_41583_) {
            for (int i = 2; i < 30; ++i) {
                ((Slot)this.f_38839_.get(i)).m_5852_(input);
            }
        }
        List<ItemStack> recipe = this.recipeFactory.getVariants(input);
        int slotIndex = 2;
        for (ItemStack variant : recipe) {
            ((Slot)this.f_38839_.get(slotIndex)).m_5852_(variant);
            ++slotIndex;
        }
        this.m_38946_();
    }

    public void craftVariant(ItemStack variantItem) {
        int count = this.inputSlot.m_7993_().m_41613_();
        ItemStack newStack = new ItemStack((ItemLike)variantItem.m_41720_(), count);
        if (this.toggle) {
            for (ItemStack stack : this.pPlayerInventory.f_35974_) {
                if (stack == ItemStack.f_41583_ || stack.m_41720_() != this.inputSlot.m_7993_().m_41720_()) continue;
                int slot = this.pPlayerInventory.m_36043_(stack);
                int stackCount = stack.m_41613_();
                ItemStack newInvStack = new ItemStack((ItemLike)variantItem.m_41720_(), stackCount);
                this.pPlayerInventory.m_6836_(slot, newInvStack);
            }
        }
        this.resultSlot.m_5852_(newStack);
        this.inputSlot.m_5852_(ItemStack.f_41583_);
        this.updateVariants(ItemStack.f_41583_);
        this.m_38946_();
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot != this.resultSlot && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex < 2 ? !this.m_38903_(itemstack1, 9, 45, true) : !this.m_38903_(itemstack1, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.resultSlot.m_6657_() && player instanceof ServerPlayer) {
            player.m_150109_().m_150079_(this.chisel.m_8016_(this.resultSlot.f_40219_));
        }
        if (this.inputSlot.m_6657_() && player instanceof ServerPlayer) {
            player.m_150109_().m_150079_(this.chisel.m_8016_(this.inputSlot.f_40219_));
        }
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (pId == 0) {
            this.toggle = false;
        } else if (pId == 1) {
            this.toggle = true;
        }
        return super.m_6366_(pPlayer, pId);
    }

    public boolean m_6875_(Player pPlayer) {
        return true;
    }
}

