/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item.neptunium;

import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.init.AquaItems;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aquaculture")
public class NeptuniumArmor
extends ArmorItem {
    private static final AttributeModifier INCREASED_SWIM_SPEED = new AttributeModifier(UUID.fromString("d820cadc-2d19-421c-b19f-4c1f5b84a418"), "Neptunium Boots swim speed boost", 0.5, AttributeModifier.Operation.ADDITION);
    private String texture;

    public NeptuniumArmor(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot) {
        super(armorMaterial, equipmentSlot, new Item.Properties().m_41491_(Aquaculture.GROUP));
    }

    public void onArmorTick(@Nonnull ItemStack stack, Level world, Player player) {
        AttributeInstance swimSpeed = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        if (player.m_204029_(FluidTags.f_13131_)) {
            if (this.f_40377_ == EquipmentSlot.HEAD) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 20, 0, false, false, false));
            } else if (this.f_40377_ == EquipmentSlot.CHEST) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 20, 0, false, false, false));
            } else if (this.f_40377_ == EquipmentSlot.LEGS && !player.m_6047_()) {
                player.m_20256_(player.m_20184_().m_82520_(0.0, (double)player.f_19789_, 0.0));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            AttributeInstance swimSpeed;
            Player player = event.player;
            if (!player.f_19853_.f_46443_ && (swimSpeed = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get())) != null) {
                if (player.m_20069_() && player.m_6844_(EquipmentSlot.FEET).m_41720_() == AquaItems.NEPTUNIUM_BOOTS.get()) {
                    if (!swimSpeed.m_22109_(INCREASED_SWIM_SPEED)) {
                        swimSpeed.m_22125_(INCREASED_SWIM_SPEED);
                    }
                } else if (swimSpeed.m_22109_(INCREASED_SWIM_SPEED)) {
                    swimSpeed.m_22130_(INCREASED_SWIM_SPEED);
                }
            }
        }
    }

    public Item setArmorTexture(String string) {
        this.texture = string;
        return this;
    }

    public String getArmorTexture(@Nonnull ItemStack stack, Entity entity, EquipmentSlot slot, String layer) {
        return "aquaculture:textures/armor/" + this.texture + ".png";
    }
}

