/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Arrays;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.CommandEvent;
import top.seraphjack.simplelogin.SLConfig;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.network.MessageRequestCommandLogin;
import top.seraphjack.simplelogin.network.MessageRequestLogin;
import top.seraphjack.simplelogin.network.NetworkLoader;
import top.seraphjack.simplelogin.server.PlayerLoginHandler;
import top.seraphjack.simplelogin.server.storage.SLStorage;

public class ServerSideEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        SimpleLogin.logger.info("Player Joined: " + event.player.func_146103_bH().getName());
        PlayerLoginHandler.instance().playerJoin((EntityPlayerMP)event.player);
        if (SLConfig.server.enableCommandLoginMode) {
            NetworkLoader.INSTANCE.sendTo((IMessage)new MessageRequestCommandLogin(SLStorage.instance().storageProvider.registered(event.player.func_146103_bH().getName())), (EntityPlayerMP)event.player);
        } else {
            NetworkLoader.INSTANCE.sendTo((IMessage)new MessageRequestLogin(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        SimpleLogin.logger.info("Player Left: " + event.player.func_146103_bH().getName());
        PlayerLoginHandler.instance().playerLeave((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        if (Arrays.asList(SLConfig.server.commandNames).contains(event.command.func_71517_b())) {
            return;
        }
        if (PlayerLoginHandler.instance().isPlayerInLoginList(event.sender.func_70005_c_())) {
            event.setCanceled(true);
            try {
                CommandBase.func_71521_c((ICommandSender)event.sender).func_145747_a((IChatComponent)new ChatComponentText("You should login first."));
            }
            catch (PlayerNotFoundException playerNotFoundException) {
                // empty catch block
            }
            SimpleLogin.logger.warn("Player " + event.sender.func_70005_c_() + " tried to use command " + event.command.func_71517_b() + " before login.");
        }
    }
}

