/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldSettings;
import top.seraphjack.simplelogin.server.storage.SLStorage;

@ParametersAreNonnullByDefault
public class SLCommand
extends CommandBase {
    public String func_71517_b() {
        return "simplelogin";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/simplelogin unregister <PlayerName>\n/simplelogin save\n/simplelogin setDefaultGameType <PlayerName> <GameType>";
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (args[0]) {
            case "unregister": {
                if (args.length != 2) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                SLStorage.instance().storageProvider.unregister(args[1]);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Player " + args[1] + " has been unregistered."));
                break;
            }
            case "save": {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Saving all entries..."));
                try {
                    long start = System.currentTimeMillis();
                    SLStorage.instance().storageProvider.save();
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Done! Took " + (System.currentTimeMillis() - start) + "ms."));
                }
                catch (IOException e) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Unable to save! Check server log for details!"));
                }
                break;
            }
            case "setDefaultGameType": {
                if (args.length != 3) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                WorldSettings.GameType gameType = WorldSettings.GameType.func_77142_a((String)args[2]);
                SLStorage.instance().storageProvider.setGameType(args[1], gameType);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Set player " + args[1] + "'s default GameMode to " + gameType.func_77149_b() + "."));
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args[0].equals("unregister") && args.length == 2) {
            return SLCommand.func_71531_a((String[])args, SLStorage.instance().storageProvider.listEntries());
        }
        if (args[0].equals("setDefaultGameType")) {
            if (args.length == 2) {
                return SLCommand.func_71531_a((String[])args, SLStorage.instance().storageProvider.listEntries());
            }
            if (args.length == 3) {
                return SLCommand.func_71531_a((String[])args, Arrays.asList("survival", "creative", "adventure", "spectator"));
            }
        } else if (args.length <= 1) {
            return SLCommand.func_71531_a((String[])args, Arrays.asList("unregister", "save", "setDefaultGameType"));
        }
        return super.func_71516_a(sender, args);
    }
}

