/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldSettings;
import top.seraphjack.simplelogin.SLConfig;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.network.MessageRequestCommandLogin;
import top.seraphjack.simplelogin.network.MessageRequestLogin;
import top.seraphjack.simplelogin.network.NetworkLoader;
import top.seraphjack.simplelogin.server.storage.SLStorage;

@SideOnly(value=Side.SERVER)
public class PlayerLoginHandler {
    private static Thread PLAYER_HANDLER_THREAD;
    private static PlayerLoginHandler INSTANCE;
    private boolean alive;
    private final ConcurrentLinkedQueue<Login> loginList = new ConcurrentLinkedQueue();
    private long lastEntriesSaved;

    private PlayerLoginHandler() {
        PLAYER_HANDLER_THREAD = new Thread(() -> {
            this.lastEntriesSaved = System.currentTimeMillis();
            while (this.alive) {
                try {
                    for (Login login : this.loginList) {
                        EntityPlayerMP player = (EntityPlayerMP)FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72924_a(login.name);
                        if (player == null) {
                            this.loginList.remove(login);
                            continue;
                        }
                        if (System.currentTimeMillis() - login.lastRequested >= 1000L) {
                            if (SLConfig.server.enableCommandLoginMode) {
                                NetworkLoader.INSTANCE.sendTo((IMessage)new MessageRequestCommandLogin(SLStorage.instance().storageProvider.registered(player.func_146103_bH().getName())), player);
                            } else {
                                NetworkLoader.INSTANCE.sendTo((IMessage)new MessageRequestLogin(), player);
                            }
                            login.lastRequested = System.currentTimeMillis();
                        }
                        player.func_70012_b(login.posX, login.posY, login.posZ, login.yaw, login.pitch);
                        if (System.currentTimeMillis() - login.time < (long)(SLConfig.server.secs * 1000)) continue;
                        player.field_71135_a.func_147360_c("Login timed out.");
                        this.loginList.removeIf(i -> i.name.equals(player.func_146103_bH().getName()));
                        SimpleLogin.logger.warn("Player " + login.name + " haven't login after a long time.");
                        this.loginList.remove(login);
                    }
                    if (System.currentTimeMillis() - this.lastEntriesSaved >= 300000L) {
                        this.lastEntriesSaved = System.currentTimeMillis();
                        if (SLStorage.instance().storageProvider.dirty()) {
                            SimpleLogin.logger.info("Auto saving entries");
                            long start = System.currentTimeMillis();
                            try {
                                SLStorage.instance().storageProvider.save();
                                SimpleLogin.logger.info("Done! Took " + (System.currentTimeMillis() - start) + "ms.");
                            }
                            catch (IOException ex) {
                                SimpleLogin.logger.error("Failed to auto save entries", (Throwable)ex);
                            }
                        }
                    }
                    if (this.loginList.isEmpty()) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    Thread.sleep(20L);
                }
                catch (Throwable e) {
                    SimpleLogin.logger.error("Exception caught in PlayerLoginHandler thread", e);
                }
            }
        }, "Simple-Login-Handler-Thread");
        this.alive = true;
        PLAYER_HANDLER_THREAD.start();
    }

    public static PlayerLoginHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerLoginHandler();
        }
        return INSTANCE;
    }

    @Nullable
    private Login getLoginByName(String name) {
        return this.loginList.stream().filter(l -> l.name.equals(name)).findAny().orElse(null);
    }

    public void login(String id, String pwd, boolean allowMistakenPassword) {
        Login login = this.getLoginByName(id);
        EntityPlayerMP player = (EntityPlayerMP)FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72924_a(id);
        if (login == null || player == null) {
            return;
        }
        if (System.currentTimeMillis() - login.lastLoginTrial < 1000L) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Login trial too frequent"));
        } else if (!SLStorage.instance().storageProvider.registered(id)) {
            SLStorage.instance().storageProvider.register(id, pwd);
            this.loginList.remove(login);
            this.afterPlayerLogin(login, player);
            SimpleLogin.logger.info("Player " + id + " has successfully registered.");
        } else if (SLStorage.instance().storageProvider.checkPassword(id, pwd)) {
            this.loginList.remove(login);
            this.afterPlayerLogin(login, player);
            SimpleLogin.logger.info("Player " + id + " has successfully logged in.");
        } else {
            SimpleLogin.logger.warn("Player " + id + " tried to login with a wrong password.");
            if (allowMistakenPassword) {
                login.lastLoginTrial = System.currentTimeMillis();
                player.func_145747_a((IChatComponent)new ChatComponentText("Password not correct, please wait for at least 1 second before trying again"));
            } else {
                this.loginList.remove(login);
                player.field_71135_a.func_147360_c("Wrong Password.");
            }
        }
    }

    public void playerJoin(EntityPlayerMP player) {
        this.loginList.add(new Login(player));
        SimpleLogin.logger.info("Setting gamemode to adventure");
        player.func_71033_a(WorldSettings.GameType.ADVENTURE);
    }

    public void playerLeave(EntityPlayerMP player) {
    }

    public boolean isPlayerInLoginList(String id) {
        return this.loginList.stream().anyMatch(e -> e.name.equals(id));
    }

    private void afterPlayerLogin(Login login, EntityPlayerMP player) {
        player.func_71033_a(SLStorage.instance().storageProvider.gameType(login.name));
    }

    void stop() {
        SimpleLogin.logger.info("Shutting down player login handler");
        this.alive = false;
        try {
            PLAYER_HANDLER_THREAD.join();
        }
        catch (InterruptedException e) {
            SimpleLogin.logger.error("Fail to shutdown login handler", (Throwable)e);
        }
    }

    static class Login {
        String name;
        long time;
        double posX;
        double posY;
        double posZ;
        float yaw;
        float pitch;
        long lastRequested;
        long lastLoginTrial;

        Login(EntityPlayerMP player) {
            this.name = player.func_146103_bH().getName();
            this.time = System.currentTimeMillis();
            this.posX = player.field_70165_t;
            this.posY = player.field_70163_u;
            this.posZ = player.field_70161_v;
            this.yaw = player.field_70177_z;
            this.pitch = player.field_70125_A;
            this.lastRequested = System.currentTimeMillis();
        }
    }
}

